/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libtraci;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.sumo.libtraci.libtraciJNI;

public class StringStringMap
extends AbstractMap<String, String> {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected StringStringMap(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(StringStringMap obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(StringStringMap obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libtraciJNI.delete_StringStringMap(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public int size() {
        return this.sizeImpl();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        return this.containsImpl((String)key);
    }

    @Override
    public String get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        Iterator itr = this.find((String)key);
        if (itr.isNot(this.end())) {
            return itr.getValue();
        }
        return null;
    }

    @Override
    public String put(String key, String value) {
        Iterator itr = this.find(key);
        if (itr.isNot(this.end())) {
            String oldValue = itr.getValue();
            itr.setValue(value);
            return oldValue;
        }
        this.putUnchecked(key, value);
        return null;
    }

    @Override
    public String remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        Iterator itr = this.find((String)key);
        if (itr.isNot(this.end())) {
            String oldValue = itr.getValue();
            this.removeUnchecked(itr);
            return oldValue;
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashSet<Map.Entry<String, String>> setToReturn = new HashSet<Map.Entry<String, String>>();
        Iterator itr = this.begin();
        Iterator end = this.end();
        while (itr.isNot(end)) {
            setToReturn.add((new Map.Entry<String, String>(){
                private Iterator iterator;

                private Map.Entry<String, String> init(Iterator iterator) {
                    this.iterator = iterator;
                    return this;
                }

                @Override
                public String getKey() {
                    return this.iterator.getKey();
                }

                @Override
                public String getValue() {
                    return this.iterator.getValue();
                }

                @Override
                public String setValue(String newValue) {
                    String oldValue = this.iterator.getValue();
                    this.iterator.setValue(newValue);
                    return oldValue;
                }
            }).init(itr));
            itr = itr.getNextUnchecked();
        }
        return setToReturn;
    }

    public StringStringMap() {
        this(libtraciJNI.new_StringStringMap__SWIG_0(), true);
    }

    public StringStringMap(StringStringMap other) {
        this(libtraciJNI.new_StringStringMap__SWIG_1(StringStringMap.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return libtraciJNI.StringStringMap_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        libtraciJNI.StringStringMap_clear(this.swigCPtr, this);
    }

    private Iterator find(String key) {
        return new Iterator(libtraciJNI.StringStringMap_find(this.swigCPtr, this, key), true);
    }

    private Iterator begin() {
        return new Iterator(libtraciJNI.StringStringMap_begin(this.swigCPtr, this), true);
    }

    private Iterator end() {
        return new Iterator(libtraciJNI.StringStringMap_end(this.swigCPtr, this), true);
    }

    private int sizeImpl() {
        return libtraciJNI.StringStringMap_sizeImpl(this.swigCPtr, this);
    }

    private boolean containsImpl(String key) {
        return libtraciJNI.StringStringMap_containsImpl(this.swigCPtr, this, key);
    }

    private void putUnchecked(String key, String value) {
        libtraciJNI.StringStringMap_putUnchecked(this.swigCPtr, this, key, value);
    }

    private void removeUnchecked(Iterator itr) {
        libtraciJNI.StringStringMap_removeUnchecked(this.swigCPtr, this, Iterator.getCPtr(itr), itr);
    }

    public static class Iterator {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected Iterator(long cPtr, boolean cMemoryOwn) {
            this.swigCMemOwn = cMemoryOwn;
            this.swigCPtr = cPtr;
        }

        protected static long getCPtr(Iterator obj) {
            return obj == null ? 0L : obj.swigCPtr;
        }

        protected static long swigRelease(Iterator obj) {
            long ptr = 0L;
            if (obj != null) {
                if (!obj.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                ptr = obj.swigCPtr;
                obj.swigCMemOwn = false;
                obj.delete();
            }
            return ptr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    libtraciJNI.delete_StringStringMap_Iterator(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        private Iterator getNextUnchecked() {
            return new Iterator(libtraciJNI.StringStringMap_Iterator_getNextUnchecked(this.swigCPtr, this), true);
        }

        private boolean isNot(Iterator other) {
            return libtraciJNI.StringStringMap_Iterator_isNot(this.swigCPtr, this, Iterator.getCPtr(other), other);
        }

        private String getKey() {
            return libtraciJNI.StringStringMap_Iterator_getKey(this.swigCPtr, this);
        }

        private String getValue() {
            return libtraciJNI.StringStringMap_Iterator_getValue(this.swigCPtr, this);
        }

        private void setValue(String newValue) {
            libtraciJNI.StringStringMap_Iterator_setValue(this.swigCPtr, this, newValue);
        }
    }
}

