/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.commons.logger;

import de.dlr.ts.commons.logger.DateTools;
import de.dlr.ts.commons.logger.LogLevel;
import de.dlr.ts.commons.logger.MyString;
import de.dlr.ts.commons.logger.ToString;
import de.dlr.ts.commons.logger.WriteToDisk;
import de.dlr.ts.commons.tools.StringTools;
import de.dlr.ts.commons.utils.print.Color;
import de.dlr.ts.commons.utils.print.ColorString;
import de.dlr.ts.commons.utils.print.Effect;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class DLRLogger {
    private static LogLevel currentLevel = LogLevel.INFO;
    private static WriteToDisk wtd = null;

    @Deprecated
    public static void setWriteToDisk(boolean writeToDisk, double logFolderSizeLimitInMB) {
        if (writeToDisk) {
            wtd = new WriteToDisk(logFolderSizeLimitInMB);
            wtd.start();
        }
    }

    public static PrintStream getSeverePrintStream() {
        return new PrintStream(new SevereOutputStream(), true);
    }

    public static void setWriteToDisk(int logFolderSizeLimitInMB) {
        if (logFolderSizeLimitInMB != 0) {
            wtd = new WriteToDisk(logFolderSizeLimitInMB);
            wtd.start();
        }
    }

    @Deprecated
    public static void setWriteToDisk(boolean writeToDisk) {
        DLRLogger.setWriteToDisk(writeToDisk, 0.0);
    }

    public static ToString toString(Object object) {
        if (object instanceof String) {
            return new ToString((String)object);
        }
        return new ToString(object.getClass().getSimpleName());
    }

    public static LogLevel getCurrentLevel() {
        return currentLevel;
    }

    private DLRLogger(LogLevel level) {
        currentLevel = level;
    }

    public static void setLevel(LogLevel level) {
        if (level != null) {
            currentLevel = level;
        }
    }

    private static ColorString getBarrita(LogLevel level) {
        switch (level) {
            case FINEST: {
                return new ColorString(" | ", Color.BLUE, Effect.BOLD);
            }
            case FINER: {
                return new ColorString(" | ", Color.CYAN, Effect.BOLD);
            }
            case FINE: {
                return new ColorString(" | ", Color.CYAN, Effect.BOLD);
            }
            case CONFIG: {
                return new ColorString(" | ", Color.MAGENTA, Effect.BOLD);
            }
            case INFO: {
                return new ColorString(" | ", Color.GREEN, Effect.BOLD);
            }
            case WARNING: {
                return new ColorString(" | ", Color.YELLOW, Effect.BOLD);
            }
            case SEVERE: {
                return new ColorString(" | ", Color.RED, Effect.BOLD);
            }
        }
        return new ColorString(" | ", Color.BLANK, Effect.BOLD);
    }

    public static String config(String text) {
        return DLRLogger.config(null, text);
    }

    public static String config(Object module, String text) {
        return DLRLogger.config(module, Color.NONE, text);
    }

    public static String config(Object module, MyString myString) {
        return DLRLogger.print(module, myString, LogLevel.CONFIG);
    }

    public static String config(MyString myString) {
        return DLRLogger.config(null, myString);
    }

    public static String config(Object module, Color color, String text) {
        return DLRLogger.config(module, new MyString(text, color));
    }

    private static String colorIt(String text, Color color) {
        if (color != null) {
            return ColorString.string(text, color, Effect.BOLD);
        }
        return text;
    }

    public static String finer(String text) {
        return DLRLogger.finer(null, text);
    }

    public static String finer(Object module, String text) {
        return DLRLogger.finer(module, Color.NONE, text);
    }

    public static String finer(Object module, MyString myString) {
        return DLRLogger.print(module, myString, LogLevel.FINER);
    }

    public static String finer(MyString myString) {
        return DLRLogger.finer(null, myString);
    }

    public static String finer(Object module, Color color, String text) {
        return DLRLogger.finer(module, new MyString(text, color));
    }

    public static String fine(String text) {
        return DLRLogger.fine(null, text);
    }

    public static String fine(Object module, String text) {
        return DLRLogger.fine(module, Color.NONE, text);
    }

    public static String fine(Object module, Color color, String text) {
        return DLRLogger.fine(module, new MyString(text, color));
    }

    public static String fine(Object module, MyString myString) {
        return DLRLogger.print(module, myString, LogLevel.FINE);
    }

    public static String fine(MyString myString) {
        return DLRLogger.fine(null, myString);
    }

    private static String module(Object module, String text) {
        if (module != null) {
            text = module instanceof String ? "[" + ColorString.string((String)module, Color.WHITE, Effect.BOLD) + "] " + text : "[" + ColorString.string(module.getClass().getSimpleName(), Color.WHITE, Effect.BOLD) + "] " + text;
        }
        return text;
    }

    private static String modulePlain(Object module, String text) {
        if (module != null) {
            text = module instanceof String ? "[" + (String)module + "] " + text : "[" + module.getClass().getSimpleName() + "] " + text;
        }
        return text;
    }

    public static String finest(String text) {
        return DLRLogger.finest(null, text);
    }

    public static String finest(Object module, String text) {
        return DLRLogger.finest(module, Color.NONE, text);
    }

    public static String finest(Object module, Color color, String text) {
        return DLRLogger.finest(module, new MyString(text, color));
    }

    public static String finest(Object module, MyString myString) {
        return DLRLogger.print(module, myString, LogLevel.FINEST);
    }

    public static String finest(MyString myString) {
        return DLRLogger.finest(null, myString);
    }

    public static String warning(String text) {
        return DLRLogger.warning(null, text);
    }

    public static String warning(Object module, String text) {
        return DLRLogger.warning(module, Color.NONE, text);
    }

    public static String warning(Object module, Color color, String text) {
        return DLRLogger.warning(module, new MyString(text, color));
    }

    public static String warning(Object module, MyString myString) {
        return DLRLogger.print(module, myString, LogLevel.WARNING);
    }

    public static String warning(MyString myString) {
        return DLRLogger.warning(null, myString);
    }

    public static String getLine(String text, String separator) {
        return DateTools.getDateStringForLogger(System.currentTimeMillis()) + separator + text;
    }

    public static String severe(String text) {
        return DLRLogger.severe(null, text);
    }

    public static String severe(Object module, String text) {
        return DLRLogger.severe(module, Color.NONE, text);
    }

    public static String severe(Object module, Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        String exceptionAsString = sw.toString();
        return DLRLogger.severe(module, Color.NONE, exceptionAsString);
    }

    public static String severe(Object module, Color color, String text) {
        return DLRLogger.severe(module, new MyString(text, color));
    }

    public static String severe(Object module, MyString myString) {
        return DLRLogger.print(module, myString, LogLevel.SEVERE);
    }

    public static String severe(MyString myString) {
        return DLRLogger.severe(null, myString);
    }

    public static String info(String text) {
        return DLRLogger.info(null, text);
    }

    public static String info(MyString myString) {
        return DLRLogger.info(null, myString);
    }

    public static String info(Object module, String text) {
        return DLRLogger.info(module, Color.NONE, text);
    }

    public static String info(Object module, Color color, String text) {
        return DLRLogger.info(module, new MyString(text, color));
    }

    public static String info(Object module, MyString myString) {
        return DLRLogger.print(module, myString, LogLevel.INFO);
    }

    @Deprecated
    public static String log(LogLevel level, String text) {
        if (wtd != null && currentLevel.ordinal() >= level.ordinal()) {
            wtd.addLogLine(DateTools.getDateStringForLogger(System.currentTimeMillis()) + " | " + StringTools.centerText(level.toString(), 7) + " | " + text);
        }
        if (level.ordinal() <= currentLevel.ordinal()) {
            ColorString barrita = DLRLogger.getBarrita(level);
            String line = DLRLogger.getLine(text, barrita.toString());
            System.out.println(line);
            return line;
        }
        return "";
    }

    private static String print(Object module, MyString myString, LogLevel logLevel) {
        if (wtd != null && currentLevel.ordinal() >= logLevel.ordinal()) {
            wtd.addLogLine(DateTools.getDateStringForLogger(System.currentTimeMillis()) + " | " + StringTools.centerText(logLevel.toString(), 7) + " | " + DLRLogger.modulePlain(module, myString.getPlainString()));
        }
        String text = "";
        if (currentLevel.ordinal() >= logLevel.ordinal()) {
            ColorString barrita = DLRLogger.getBarrita(logLevel);
            text = myString.toString();
            text = DLRLogger.module(module, text);
            String line = DLRLogger.getLine(text, barrita.toString());
            if (logLevel != LogLevel.SEVERE) {
                System.out.println(line);
            } else {
                System.err.println(line);
            }
            return line;
        }
        return text;
    }

    private static class SevereOutputStream
    extends OutputStream {
        private StringBuilder string = new StringBuilder();

        private SevereOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (b != 13 && b != 10) {
                this.string.append((char)b);
            }
        }

        @Override
        public void flush() throws IOException {
            DLRLogger.severe(this.string.toString());
            this.string = new StringBuilder();
        }
    }
}

