/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.commons.tools;

import de.dlr.ts.commons.tools.BytesTools;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;

public class MathTools {
    public static int getInteger(byte b0, byte b1) {
        int a = MathTools.toUnsignedInteger(b0);
        int b = MathTools.toUnsignedInteger(b1);
        return (a <<= 8) + b;
    }

    public static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static final byte[] longToByteArray(long value) {
        return new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static int getInteger(byte b0, byte b1, byte b2, byte b3) {
        int in1 = MathTools.getInteger(b0, b1);
        int in2 = MathTools.getInteger(b2, b3);
        return (in1 <<= 16) + in2;
    }

    public static long getLong(byte b0, byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7) {
        long in0 = MathTools.toUnsignedLong(b0) << 56;
        long in1 = MathTools.toUnsignedLong(b1) << 48;
        long in2 = MathTools.toUnsignedLong(b2) << 40;
        long in3 = MathTools.toUnsignedLong(b3) << 32;
        long in4 = MathTools.toUnsignedLong(b4) << 24;
        long in5 = MathTools.toUnsignedLong(b5) << 16;
        long in6 = MathTools.toUnsignedLong(b6) << 8;
        long in7 = MathTools.toUnsignedLong(b7);
        return in0 + in1 + in2 + in3 + in4 + in5 + in6 + in7;
    }

    public static int randInt(int min, int max) {
        Random rand = new Random();
        int randomNum = rand.nextInt(max - min + 1) + min;
        return randomNum;
    }

    public static double roundUp(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static long roundUp(long value, int places) {
        long aa = (long)Math.pow(10.0, places);
        if (value % aa == 0L) {
            return value;
        }
        long tmp = value / aa;
        return ++tmp * aa;
    }

    public static long roundHalf(long value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        int plac = (int)Math.pow(10.0, places);
        double tmp = value;
        double tronco = (long)(tmp /= (double)plac) * (long)plac;
        double resto = (double)value - tronco;
        if (resto >= (double)(plac / 2)) {
            tronco += (double)plac;
        }
        return (long)tronco;
    }

    public static int roundHalf(int value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        int plac = (int)Math.pow(10.0, places);
        double tmp = value;
        double tronco = (int)(tmp /= (double)plac) * plac;
        double resto = (double)value - tronco;
        if (resto >= (double)(plac / 2)) {
            tronco += (double)plac;
        }
        return (int)tronco;
    }

    public static int toUnsignedInteger(byte b) {
        return Integer.parseInt(BytesTools.bytesToBinaryString(b), 2);
    }

    public static long toUnsignedLong(byte b) {
        return Long.parseLong(BytesTools.bytesToBinaryString(b), 2);
    }

    public static long toUnsignedLong(int i) {
        return Long.parseLong(Integer.toBinaryString(i), 2);
    }

    public static byte[] reverseArray(byte ... bytes) {
        byte[] temp = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            temp[i] = bytes[bytes.length - 1 - i];
        }
        return temp;
    }
}

