/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.lisa;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.lisum.exceptions.LisaRESTfulServerNotFoundException;
import de.dlr.ts.lisum.interfaces.CityInterface;
import de.dlr.ts.lisum.interfaces.ControlUnitInterface;
import de.dlr.ts.lisum.lisa.LisaCommands;
import de.dlr.ts.lisum.lisa.LisaConfigurationFiles;
import de.dlr.ts.lisum.lisa.LisaControlUnits;
import de.dlr.ts.lisum.simulation.LisumSimulation;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class Lisa
implements CityInterface {
    private final LisaCommands lisaCommands;
    private final LisaControlUnits lisaControlUnits = new LisaControlUnits();
    private File lisaDirectory;
    private static ComparableVersion lisaVersion = new ComparableVersion("7.2");

    private Lisa(String lisaServerAddress, int lisaServerPort) {
        this.lisaCommands = new LisaCommands(lisaServerAddress, lisaServerPort);
    }

    @Override
    public ControlUnitInterface[] getControlUnits() {
        return this.lisaControlUnits.getControlUnits();
    }

    public static CityInterface create(String lisaServerAddress, int lisaServerPort) {
        return new Lisa(lisaServerAddress, lisaServerPort);
    }

    @Override
    public void load(File lisaDirectory) {
        DLRLogger.config((Object)this, "Loading directory " + lisaDirectory);
        if (!lisaDirectory.exists()) {
            DLRLogger.severe((Object)this, lisaDirectory + " could not be found");
            return;
        }
        this.lisaDirectory = lisaDirectory;
        LisaConfigurationFiles configurationFiles = new LisaConfigurationFiles();
        configurationFiles.load(lisaDirectory);
        this.lisaControlUnits.load(configurationFiles, this.lisaCommands);
    }

    @Override
    public LisumSimulation.InitBeforePlayResponse initBeforePlay() {
        if (!LisaCommands.TestRESTfulServer()) {
            return LisumSimulation.InitBeforePlayResponse.LisaRESTfulServerNotFound;
        }
        try {
            this.lisaCommands.setDataDir(this.lisaDirectory);
            this.lisaControlUnits.initBeforePlay();
        }
        catch (LisaRESTfulServerNotFoundException ex) {
            Logger.getLogger(Lisa.class.getName()).log(Level.SEVERE, null, ex);
        }
        return LisumSimulation.InitBeforePlayResponse.OK;
    }

    @Override
    public void executeSimulationStep(long simulationTime) {
        try {
            this.lisaControlUnits.executeSimulationStep(simulationTime);
        }
        catch (LisaRESTfulServerNotFoundException ex) {
            ex.printStackTrace(System.out);
        }
    }

    @Override
    public ControlUnitInterface getControlUnit(String name) {
        return this.lisaControlUnits.getControlUnit(name);
    }

    public static void setVersion(String lisaVersionString) {
        lisaVersion = new ComparableVersion(lisaVersionString);
    }

    public static boolean minVersion(ComparableVersion version) {
        return lisaVersion.compareTo(version) >= 0;
    }
}

