/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.lisa;

import de.dlr.ts.lisum.interfaces.SignalProgramInterface;
import de.dlr.ts.lisum.lisa.LisaConfigurationFiles;
import de.dlr.ts.lisum.lisa.LisaSignalProgram;
import java.util.ArrayList;
import java.util.List;

class LisaSignalPrograms {
    private final List<LisaSignalProgram> signalPrograms = new ArrayList<LisaSignalProgram>();
    private LisaSignalProgram currentSignalProgram = null;

    public void setCurrentSignalProgram(int signalProgramNameIndex) {
        this.currentSignalProgram = this.signalPrograms.get(signalProgramNameIndex);
    }

    public LisaSignalProgram get(String name) {
        if (name == null) {
            return null;
        }
        for (LisaSignalProgram signalProgram : this.signalPrograms) {
            if (!signalProgram.getName().equals(name)) continue;
            return signalProgram;
        }
        return null;
    }

    public LisaSignalProgram get(int index) {
        if (index >= this.signalPrograms.size() || index < 0) {
            return null;
        }
        return this.signalPrograms.get(index);
    }

    public LisaSignalProgram getCurrentSignalProgram() {
        return this.currentSignalProgram;
    }

    public int getCurrentSignalProgramIndex() {
        return this.signalPrograms.indexOf(this.currentSignalProgram);
    }

    public SignalProgramInterface[] getSignalProgramsArray() {
        return this.signalPrograms.toArray(new SignalProgramInterface[this.signalPrograms.size()]);
    }

    public void load(LisaConfigurationFiles.ControlUnit controlUnitConf) {
        LisaSignalProgram sp = new LisaSignalProgram("Off", 0);
        this.signalPrograms.add(sp);
        for (LisaConfigurationFiles.ControlUnit.SignalProgram signalProgram : controlUnitConf.signalPrograms) {
            sp = new LisaSignalProgram(signalProgram.bezeichnung, signalProgram.objNr);
            this.signalPrograms.add(sp);
        }
    }
}

