/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.lisa;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.lisum.lisa.LisaControlUnit;
import de.dlr.ts.lisum.lisa.WunschVector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

class Persistence {
    private final Properties properties = new Properties();
    private final WunschVector vector;
    private final LisaControlUnit controlUnit;
    private final File persistenceFile;

    public Persistence(WunschVector vector, File lisaDirectory, LisaControlUnit controlUnit) {
        this.vector = vector;
        this.controlUnit = controlUnit;
        this.persistenceFile = new File(lisaDirectory.getAbsolutePath() + File.separator + this.controlUnit.getFullName() + ".per");
    }

    public void store() {
        this.properties.put("ebene", String.valueOf(this.vector.getEbene()));
        this.properties.put("knoteneinaus", String.valueOf(this.vector.getKnotenEinAus()));
        this.properties.put("va", String.valueOf(this.vector.isVA()));
        this.properties.put("iv", String.valueOf(this.vector.isIV()));
        this.properties.put("ov", String.valueOf(this.vector.isOV()));
        this.properties.put("betriebsart", String.valueOf(this.vector.getBetriebsArt()));
        this.properties.put("signalprogram", String.valueOf(this.vector.getSignalProgramIndex()));
        try {
            FileOutputStream out = new FileOutputStream(this.persistenceFile);
            this.properties.store(out, "LiSuM: Persistence file");
        }
        catch (FileNotFoundException ex) {
            DLRLogger.severe((Object)this, "Error storing control unit properties to " + this.persistenceFile.getAbsolutePath());
        }
        catch (IOException ex) {
            DLRLogger.severe((Object)this, "Error storing control unit properties to " + this.persistenceFile.getAbsolutePath());
        }
    }

    void readPersistence() {
        if (this.persistenceFile.exists()) {
            try {
                this.properties.load(new FileInputStream(this.persistenceFile));
                String ebene = this.properties.getProperty("ebene", String.valueOf(this.controlUnit.getEbene()));
                int ebe = Integer.valueOf(ebene);
                if (ebe >= 0) {
                    this.controlUnit.setEbene(ebe);
                }
                String einaus = this.properties.getProperty("knoteneinaus", String.valueOf(this.controlUnit.getKnotenEinAus()));
                this.controlUnit.setKnotenEinAus(Integer.valueOf(einaus));
                String va = this.properties.getProperty("va", String.valueOf(this.controlUnit.isVA()));
                this.controlUnit.setVA(Boolean.valueOf(va));
                String iv = this.properties.getProperty("iv", String.valueOf(this.controlUnit.isIV()));
                this.controlUnit.setIV(Boolean.valueOf(iv));
                String ov = this.properties.getProperty("ov", String.valueOf(this.controlUnit.isOV()));
                this.controlUnit.setOV(Boolean.valueOf(ov));
                String sp = this.properties.getProperty("signalprogram", String.valueOf(this.vector.getSignalProgramIndex()));
                int dd = Integer.valueOf(sp);
                if (dd >= 0) {
                    this.controlUnit.setCurrentSignalProgram(dd);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.out);
            }
        }
    }
}

