/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.sumo;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.lisum.interfaces.DetectorInterface;
import de.dlr.ts.lisum.sumo.SumoDetector;
import de.dlr.ts.utils.xmladmin2.MalformedKeyOrNameException;
import de.dlr.ts.utils.xmladmin2.XMLAdmin2;
import de.dlr.ts.utils.xmladmin2.XMLNodeNotFoundException;
import it.polito.appeal.traci.SumoTraciConnection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

class SumoDetectors {
    private final List<SumoDetector> detectors = new ArrayList<SumoDetector>();
    private SumoTraciConnection conn;

    public SumoDetectors(SumoTraciConnection conn) {
        this.conn = conn;
    }

    public void executeSimulationStep() throws Exception {
        for (SumoDetector detector : this.detectors) {
            detector.executeSimulationStep();
        }
    }

    public void addDetector(String name, DetectorInterface cityDetector) {
        SumoDetector sd = new SumoDetector(name, this.conn);
        sd.setCityDetector(cityDetector);
        this.detectors.add(sd);
        DLRLogger.info((Object)this, "Adding detector " + sd);
    }

    public void load(File sumoAddFile) {
        if (sumoAddFile == null) {
            return;
        }
        try {
            XMLAdmin2 x = new XMLAdmin2().load(sumoAddFile);
            int nodesCount = x.getNodesCount("inductionLoop");
            for (int i = 0; i < nodesCount; ++i) {
                String name = x.getNode("inductionLoop", i).getAttributes().get("id").getValue();
                SumoDetector sd = new SumoDetector(name, this.conn);
                this.detectors.add(sd);
                DLRLogger.info((Object)this, "Adding detector " + sd);
            }
        }
        catch (MalformedKeyOrNameException | XMLNodeNotFoundException | IOException | SAXException ex) {
            ex.printStackTrace(System.out);
        }
    }

    public SumoDetector getSumoDetector(int index) {
        return this.detectors.get(index);
    }

    public SumoDetector getSumoDetector(String name) {
        for (SumoDetector detector : this.detectors) {
            if (!detector.getName().equals(name)) continue;
            return detector;
        }
        return null;
    }
}

