/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.utils.xmladmin2;

import de.dlr.ts.utils.xmladmin2.Attribute;
import java.util.ArrayList;
import java.util.List;

public class Attributes
implements Comparable<Attributes> {
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public boolean hasAttribute(String name, String value) {
        return this.hasAttribute(new Attribute(name, value));
    }

    public String getXML() {
        StringBuilder sb = new StringBuilder(" ");
        for (Attribute ka : this.attributes) {
            sb.append(ka.getName());
            sb.append("=\"");
            sb.append(ka.getValue());
            sb.append("\" ");
        }
        return sb.toString();
    }

    public String toString() {
        String tmp = "";
        for (Attribute ka : this.attributes) {
            tmp = tmp + " " + ka;
        }
        return tmp.trim();
    }

    public void add(String name, String value) {
        this.attributes.add(new Attribute(name, value));
    }

    public void add(Attribute ka) {
        this.attributes.add(ka);
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public int size() {
        return this.attributes.size();
    }

    public Attribute get(int index) {
        return this.attributes.get(index);
    }

    public Attribute get(String attributeName) {
        for (Attribute att : this.attributes) {
            if (!att.getName().equals(attributeName)) continue;
            return att;
        }
        return null;
    }

    @Override
    public int compareTo(Attributes o) {
        if (o.attributes.size() != this.attributes.size()) {
            return 1;
        }
        for (Attribute ka : o.attributes) {
            if (this.hasAttribute(ka)) continue;
            return 2;
        }
        return 0;
    }

    public boolean hasAttribute(Attribute ka) {
        for (Attribute o : this.attributes) {
            if (ka.compareTo(o) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttribute(String attributeName) {
        for (Attribute get : this.attributes) {
            if (!get.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }
}

