/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.utils.xmladmin2;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.utils.xmladmin2.MalformedKeyOrNameException;
import de.dlr.ts.utils.xmladmin2.Tools;
import de.dlr.ts.utils.xmladmin2.XMLNode;
import de.dlr.ts.utils.xmladmin2.XMLNodeNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLAdmin2 {
    public static final String xmlDeclarator = "<?xml version='1.0' encoding='UTF-8'?>";
    private DocumentBuilderFactory dbFactory;
    private DocumentBuilder dBuilder;
    private Document doc;
    private Element root;
    private XMLNode rootNode;
    private boolean includeDeclarator = true;

    public void setName(String name) {
        this.rootNode.setName(name);
    }

    public XMLNode getNode(int index) {
        return this.rootNode.getNode(index);
    }

    public int getNodesCount() throws MalformedKeyOrNameException, XMLNodeNotFoundException {
        return this.rootNode.getNodesCount("*");
    }

    static void printException(Throwable throwable) {
        DLRLogger.severe((Object)"XMLAdmin2", throwable);
    }

    static void printException(String message) {
        DLRLogger.severe((Object)"XMLAdmin2", message);
    }

    public boolean isIncludeDeclarator() {
        return this.includeDeclarator;
    }

    public void setIncludeDeclarator(boolean includeDeclarator) {
        this.includeDeclarator = includeDeclarator;
    }

    public String getXML(boolean formatted) {
        int a = 0;
        if (!formatted) {
            a = -1;
        }
        String indent = "";
        if (formatted) {
            indent = "\n";
        }
        if (this.includeDeclarator) {
            return xmlDeclarator + indent + this.rootNode.getXML(a);
        }
        return this.rootNode.getXML(a);
    }

    public XMLNode getRootNode() {
        return this.rootNode;
    }

    public XMLNode getNode(String key) throws MalformedKeyOrNameException, XMLNodeNotFoundException {
        return this.rootNode.getNode(key);
    }

    public boolean hasNode(String key) throws MalformedKeyOrNameException {
        return this.rootNode.hasNode(key);
    }

    public XMLNode getNode(String key, int occurrence) throws XMLNodeNotFoundException, MalformedKeyOrNameException {
        return this.rootNode.getNode(key, occurrence);
    }

    public int getNodesCount(String key) throws MalformedKeyOrNameException, XMLNodeNotFoundException {
        return this.rootNode.getNodesCount(key);
    }

    public XMLAdmin2() {
        try {
            this.rootNode = new XMLNode("defaultName");
        }
        catch (MalformedKeyOrNameException ex) {
            XMLAdmin2.printException(ex);
        }
        this.createBuilders();
    }

    private void createBuilders() {
        this.dbFactory = DocumentBuilderFactory.newInstance();
        try {
            this.dBuilder = this.dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            XMLAdmin2.printException(ex);
        }
    }

    public XMLAdmin2 load(String xmlFileName) throws SAXException, IOException, MalformedKeyOrNameException {
        this.load(new File(xmlFileName));
        return this;
    }

    public XMLAdmin2 load(File file) throws SAXException, IOException, MalformedKeyOrNameException {
        this.doc = this.dBuilder.parse(file);
        this.root = this.doc.getDocumentElement();
        Tools.extract(this.root, this.rootNode);
        return this;
    }

    public XMLAdmin2 load(byte[] bytes) throws SAXException, MalformedKeyOrNameException {
        try {
            this.dbFactory.setNamespaceAware(true);
            this.doc = this.dBuilder.parse(new ByteArrayInputStream(bytes));
            this.root = this.doc.getDocumentElement();
            Tools.extract(this.root, this.rootNode);
            return this;
        }
        catch (IOException ex) {
            XMLAdmin2.printException(ex);
            return null;
        }
    }

    public XMLAdmin2 load(InputStream is) throws SAXException, MalformedKeyOrNameException {
        try {
            this.dbFactory.setNamespaceAware(true);
            this.doc = this.dBuilder.parse(new InputSource(is));
            this.root = this.doc.getDocumentElement();
            Tools.extract(this.root, this.rootNode);
            return this;
        }
        catch (IOException ex) {
            XMLAdmin2.printException(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToDisc(String fileName, boolean indentation) {
        if (!fileName.endsWith(".xml")) {
            fileName = fileName + ".xml";
        }
        FileOutputStream fos = null;
        try {
            String xml = this.getXML(true);
            fos = new FileOutputStream(fileName);
            fos.write(xml.getBytes(), 0, xml.getBytes().length);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

