/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.calibrators;

import floetteroed.cadyts.calibrators.Analyzer;
import floetteroed.cadyts.calibrators.StreamFlushHandler;
import floetteroed.cadyts.demand.Demand;
import floetteroed.cadyts.demand.Plan;
import floetteroed.cadyts.demand.PlanBuilder;
import floetteroed.cadyts.measurements.MultiLinkMeasurement;
import floetteroed.cadyts.measurements.SingleLinkMeasurement;
import floetteroed.cadyts.supply.LinkLoading;
import floetteroed.cadyts.supply.LinkLoadingLocal;
import floetteroed.cadyts.supply.LinkLoadingProportional;
import floetteroed.cadyts.supply.SimResults;
import floetteroed.utilities.DynamicData;
import floetteroed.utilities.SimpleLogFormatter;
import floetteroed.utilities.math.Vector;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Calibrator<L>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String VERSION = "1.1.0";
    public static final String BASE_PACKAGE = "";
    protected final String myName = this.getClass().getName();
    public static final long DEFAULT_RANDOM_SEED = 0L;
    public static final double DEFAULT_REGRESSION_INERTIA = 0.95;
    public static final int DEFAULT_FREEZE_ITERATION = Integer.MAX_VALUE;
    public static final double DEFAULT_VARIANCE_SCALE = 1.0;
    public static final double DEFAULT_MIN_FLOW_STDDEV_VEH_H = 25.0;
    public static final double DEFAULT_MIN_COUNT_STDDEV_VEH = 25.0;
    public static final int DEFAULT_PREPARATORY_ITERATIONS = 1;
    public static final boolean DEFAULT_CENTER_REGRESSION = false;
    public static final String DEFAULT_STATISTICS_FILE = "calibration-stats.txt";
    public static final boolean DEFAULT_PROPORTIONAL_ASSIGNMENT = false;
    public static final boolean DEFAULT_DEBUG_MODE = false;
    public static final String DEFAULT_FLOW_ANALYSIS_FILE = null;
    public static final boolean DEFAULT_COUNT_FIRST_LINK = false;
    public static final boolean DEFAULT_COUNT_LAST_LINK = true;
    private final String logFile;
    private final long randomSeed;
    private final Analyzer<L> analyzer;
    private final Random random;
    private final Map<SingleLinkMeasurement.TYPE, Double> type2minStddev;
    private double regressionInertia = 0.95;
    private int freezeIteration = Integer.MAX_VALUE;
    private double varianceScale = 1.0;
    private int preparatoryIterations = 1;
    private boolean centerRegression = false;
    private String statisticsFile = "calibration-stats.txt";
    private boolean proportionalAssignment = false;
    private boolean debugMode = false;
    private String flowAnalysisFile = DEFAULT_FLOW_ANALYSIS_FILE;
    private boolean countFirstLink = false;
    private boolean countLastLink = true;
    private int iteration = 0;

    public Calibrator(String logFile, Long randomSeed, int timeBinSize_s) {
        this.logFile = logFile;
        boolean couldNotDeleteOldLogfile = logFile != null ? !new File(logFile).delete() : false;
        this.initLogging();
        if (couldNotDeleteOldLogfile) {
            Logger.getLogger(this.getClass().getName()).warning("unable to delete old logfile");
        }
        Logger.getLogger(this.getClass().getName()).info("starting " + this.getClass().getSimpleName() + " version 1.1.0");
        if (randomSeed == null) {
            Logger.getLogger(this.getClass().getName()).warning("using default random seed");
            randomSeed = 0L;
        }
        int dayLength_s = 86400;
        int timeBinCnt = 86400 / timeBinSize_s;
        if (timeBinCnt * timeBinSize_s != 86400) {
            throw new IllegalArgumentException("day length (86400 s) must be an integer multiple of timeBinSize_s");
        }
        Logger.getLogger(this.getClass().getName()).info("initializing with randomSeed = " + randomSeed + ", timeBinSize_s = " + timeBinSize_s + ", timeBinCnt = " + timeBinCnt);
        this.randomSeed = randomSeed;
        this.random = new Random(randomSeed);
        this.analyzer = new Analyzer(0, timeBinSize_s, timeBinCnt);
        Logger.getLogger(this.myName).info("default regressionInertia is " + this.regressionInertia);
        Logger.getLogger(this.myName).info("default freezeIteration is " + this.freezeIteration);
        Logger.getLogger(this.myName).info("default varianceScale is " + this.varianceScale);
        Logger.getLogger(this.myName).info("default preparatoryIterations is " + this.preparatoryIterations);
        Logger.getLogger(this.myName).info("default centerRegression is " + this.centerRegression);
        Logger.getLogger(this.myName).info("default statisticsFile is " + this.statisticsFile);
        Logger.getLogger(this.myName).info("default proportionalAssignment is " + this.proportionalAssignment);
        Logger.getLogger(this.myName).info("default debugMode is " + this.debugMode);
        Logger.getLogger(this.myName).info("default flowAnalysisFile is " + this.flowAnalysisFile);
        Logger.getLogger(this.myName).info("default countFirstLink is " + this.countFirstLink);
        Logger.getLogger(this.myName).info("default countLastLink is " + this.countLastLink);
        this.type2minStddev = new HashMap<SingleLinkMeasurement.TYPE, Double>();
        this.type2minStddev.put(SingleLinkMeasurement.TYPE.FLOW_VEH_H, 25.0);
        this.type2minStddev.put(SingleLinkMeasurement.TYPE.COUNT_VEH, 25.0);
        for (Map.Entry<SingleLinkMeasurement.TYPE, Double> entry : this.type2minStddev.entrySet()) {
            Logger.getLogger(this.myName).info("default minimum standard deviation for " + (Object)((Object)entry.getKey()) + " is " + entry.getValue());
        }
    }

    private void initLogging() {
        Logger logger = Logger.getLogger(BASE_PACKAGE);
        logger.setUseParentHandlers(false);
        for (Handler h : logger.getHandlers()) {
            h.flush();
            if (h instanceof FileHandler) {
                h.close();
            }
            logger.removeHandler(h);
        }
        StreamFlushHandler stdOutHandler = new StreamFlushHandler(System.out, new SimpleLogFormatter("Calibration "));
        logger.addHandler(stdOutHandler);
        if (this.logFile != null) {
            try {
                FileHandler fileHandler = new FileHandler(this.logFile, true);
                fileHandler.setFormatter(new SimpleLogFormatter(null));
                logger.addHandler(fileHandler);
            }
            catch (IOException e) {
                logger.warning("unable to create " + this.logFile);
            }
        }
        this.setLogLevel();
    }

    private void setLogLevel() {
        Level level = this.debugMode ? Level.FINE : Level.INFO;
        Logger logger = Logger.getLogger(BASE_PACKAGE);
        logger.setLevel(level);
        for (Handler h : logger.getHandlers()) {
            h.setLevel(level);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initLogging();
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public Random getRandom() {
        return this.random;
    }

    public int getTimeBinSize_s() {
        return this.analyzer.getBinSize_s();
    }

    public int getIteration() {
        return this.iteration;
    }

    public DynamicData<L> getLinkCostOffsets() {
        Logger.getLogger(this.getClass().getName()).warning("link cost offsets only account for single-link measurements");
        return this.analyzer.getLinkCostOffsets();
    }

    public void setRegressionInertia(double regressionInertia) {
        if (regressionInertia <= 0.0 || regressionInertia > 1.0) {
            throw new IllegalArgumentException("regressionInertia must be in (0,1]");
        }
        this.regressionInertia = regressionInertia;
        Logger.getLogger(this.myName).info("set regressionInertia to " + this.regressionInertia);
    }

    public double getRegressionInertia() {
        return this.regressionInertia;
    }

    public void setFreezeIteration(int freezeIteration) {
        if (freezeIteration < 0) {
            throw new IllegalArgumentException("freezeIteration must be at least 0");
        }
        this.freezeIteration = freezeIteration;
        Logger.getLogger(this.myName).info("set freezeIteration to " + this.freezeIteration);
        if (this.freezeIteration < this.iteration) {
            Logger.getLogger(this.myName).warning("new freeze iteration " + this.freezeIteration + " will have no effect because current iteration is already " + this.iteration);
        }
    }

    public int getFreezeIteration() {
        return this.freezeIteration;
    }

    public void setVarianceScale(double varianceScale) {
        if (varianceScale <= 0.0) {
            throw new IllegalArgumentException("varianceScale must be strictly positive");
        }
        this.varianceScale = varianceScale;
        Logger.getLogger(this.myName).info("set varianceScale to " + this.varianceScale);
    }

    public double getVarianceScale() {
        return this.varianceScale;
    }

    public void setMinStddev(double minStddev, SingleLinkMeasurement.TYPE type) {
        if (minStddev <= 0.0) {
            throw new IllegalArgumentException("minStddev for must be strictly positive");
        }
        if (type == null) {
            throw new IllegalArgumentException("measurement type must not be null");
        }
        this.type2minStddev.put(type, minStddev);
        Logger.getLogger(this.myName).info("set minimum standard deviation for " + type + " to " + this.type2minStddev.get((Object)type));
    }

    public double getMinStddev(SingleLinkMeasurement.TYPE type) {
        return this.type2minStddev.get((Object)type);
    }

    public void setPreparatoryIterations(int preparatoryIterations) {
        if (preparatoryIterations < 1) {
            throw new IllegalArgumentException("preparatoryIterations must at least be one");
        }
        this.preparatoryIterations = preparatoryIterations;
        Logger.getLogger(this.myName).info("set preparatoryIterations to " + this.preparatoryIterations);
    }

    public int getPreparatoryIterations() {
        return this.preparatoryIterations;
    }

    public void setCenterRegression(boolean centerRegression) {
        this.centerRegression = centerRegression;
        Logger.getLogger(this.myName).info("set centerRegression to " + this.centerRegression);
    }

    public boolean getCenterRegression() {
        return this.centerRegression;
    }

    public void setStatisticsFile(String statisticsFile) {
        this.analyzer.setStatisticsFile(statisticsFile);
        Logger.getLogger(this.myName).info("set statisticsFile to " + this.getStatisticsFile());
    }

    public String getStatisticsFile() {
        return this.analyzer.getStatisticsFile();
    }

    public void setProportionalAssignment(boolean proportionalAssignment) {
        this.proportionalAssignment = proportionalAssignment;
        Logger.getLogger(this.myName).info("set proportionalAssignment to " + this.proportionalAssignment);
    }

    public boolean getProportionalAssignment() {
        return this.proportionalAssignment;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
        this.setLogLevel();
        Logger.getLogger(this.myName).info("set debugMode to " + this.debugMode);
    }

    public boolean getDebugMode() {
        return this.debugMode;
    }

    public void setFlowAnalysisFile(String flowAnalysisFile) {
        this.flowAnalysisFile = flowAnalysisFile;
        Logger.getLogger(this.myName).info("set flowAnalysisFile to " + this.flowAnalysisFile);
    }

    public String getFlowAnalysisFile() {
        return this.flowAnalysisFile;
    }

    public void setCountFirstLink(boolean countFirstLink) {
        this.countFirstLink = countFirstLink;
        Logger.getLogger(this.myName).info("set countFirstLink to " + this.countFirstLink);
    }

    public boolean getCountFirstLink() {
        return this.countFirstLink;
    }

    public void setCountLastLink(boolean countLastLink) {
        this.countLastLink = countLastLink;
        Logger.getLogger(this.myName).info("set countLastLink to " + this.countLastLink);
    }

    public boolean getCountLastLink() {
        return this.countLastLink;
    }

    public PlanBuilder<L> newPlanBuilder() {
        return new PlanBuilder(this.countFirstLink, this.countLastLink);
    }

    public double calcLinearPlanEffect(Plan<L> plan) {
        if (this.iteration >= this.preparatoryIterations) {
            return this.analyzer.calcLinearPlanEffect(plan);
        }
        return 0.0;
    }

    public void addToDemand(Plan<L> plan) {
        this.analyzer.notifyPlanChoice(plan);
    }

    protected void freeze() {
        Logger.getLogger(this.myName).fine("entering");
        Logger.getLogger(this.myName).info("freezing all learning procedures");
        this.analyzer.freeze();
        Logger.getLogger(this.myName).fine("exiting");
    }

    public LinkLoading<L> newLinkLoading(L link, int start_s, int end_s, SingleLinkMeasurement.TYPE type) {
        if (this.getProportionalAssignment()) {
            return new LinkLoadingProportional<L>(link, start_s, end_s, type, this.getRegressionInertia());
        }
        return new LinkLoadingLocal<L>(link, start_s, end_s, this.getRegressionInertia(), this.getCenterRegression());
    }

    public void addMeasurement(SingleLinkMeasurement<L> meas) {
        Logger.getLogger(this.myName).fine("entering");
        if (meas == null) {
            throw new IllegalArgumentException("measurement is null");
        }
        meas.init(this);
        this.analyzer.addMeasurement(meas);
        Logger.getLogger(this.getClass().getName()).info("added " + meas);
        Logger.getLogger(this.myName).fine("exiting");
    }

    public void addMeasurement(L link, int start_s, int end_s, double value, double stddev, SingleLinkMeasurement.TYPE type) {
        Logger.getLogger(this.myName).fine("entering");
        SingleLinkMeasurement<L> meas = new SingleLinkMeasurement<L>(link, value, stddev * stddev, start_s, end_s, type);
        this.addMeasurement(meas);
        Logger.getLogger(this.myName).fine("exiting");
    }

    public void addMeasurement(L link, int start_s, int end_s, double value, SingleLinkMeasurement.TYPE type) {
        Logger.getLogger(this.myName).fine("entering");
        double stddev = Math.max(this.getMinStddev(type), Math.sqrt(this.getVarianceScale() * value));
        this.addMeasurement(link, start_s, end_s, value, stddev, type);
        Logger.getLogger(this.myName).fine("exiting");
    }

    public void addMeasurement(MultiLinkMeasurement<L> meas) {
        Logger.getLogger(this.myName).fine("entering");
        if (meas == null) {
            throw new IllegalArgumentException("measurement is null");
        }
        meas.init(this);
        this.analyzer.addMeasurement(meas);
        Logger.getLogger(this.getClass().getName()).info("added " + meas);
        Logger.getLogger(this.myName).fine("exiting");
    }

    public void afterNetworkLoading(SimResults<L> simResults) {
        Logger.getLogger(this.myName).fine("entering");
        if (this.iteration == 0 && this.regressionInertia == 1.0 || this.iteration == this.freezeIteration) {
            this.freeze();
        }
        this.analyzer.afterNetworkLoading(simResults, this.flowAnalysisFile);
        ++this.iteration;
        Logger.getLogger(this.myName).fine("exiting");
    }

    public Plan<L> newReducedPlan(Plan<L> fullPlan) {
        return this.analyzer.newReducedPlan(fullPlan);
    }

    public int getBinSize_s() {
        return this.analyzer.getBinSize_s();
    }

    public int getBinCnt() {
        return this.analyzer.getBinCnt();
    }

    public double logLikelihood(Demand<L> demand) {
        return this.analyzer.logLikelihood(demand);
    }

    public double d_logLikelihood_dPlanChoiceProba(Plan<L> plan, Demand<L> demand) {
        return this.analyzer.d_logLikelihood_dPlanChoiceProba(plan, demand);
    }

    public Vector residuals(Demand<L> demand) {
        return this.analyzer.residuals(demand);
    }

    public Vector dResiduals_dLinkDemand() {
        return this.analyzer.dResiduals_dLinkDemand();
    }

    public List<Integer> affectedMeasurementIndices(Plan<L> plan) {
        return this.analyzer.affectedMeasurementIndices(plan);
    }
}

