/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.calibrators.analytical;

import floetteroed.cadyts.calibrators.Calibrator;
import floetteroed.cadyts.demand.Plan;
import floetteroed.utilities.math.MathHelpers;
import floetteroed.utilities.math.Vector;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class AnalyticalCalibrator<L>
extends Calibrator<L> {
    private static final long serialVersionUID = 1L;
    protected static final double MIN_PROB = 1.0E-6;
    public static final boolean DEFAULT_BRUTE_FORCE = false;
    private Vector lastChoiceProbs;
    private int lastChoiceIndex;
    private boolean bruteForce = false;

    public AnalyticalCalibrator(String logFile, Long randomSeed, int timeBinSize_s) {
        super(logFile, randomSeed, timeBinSize_s);
        Logger.getLogger(this.myName).info("default bruteForce is " + this.bruteForce);
    }

    public void setBruteForce(boolean bruteForce) {
        this.bruteForce = bruteForce;
        Logger.getLogger(this.myName).info("set bruteForce to " + this.bruteForce);
    }

    public boolean getBruteForce() {
        return this.bruteForce;
    }

    public Vector getLastChoiceProbs() {
        return this.lastChoiceProbs;
    }

    public double getLastChoiceProb(int index) {
        return this.lastChoiceProbs.get(index);
    }

    public int getLastChoiceIndex() {
        return this.lastChoiceIndex;
    }

    public int selectPlan(List<? extends Plan<L>> plans, Vector choiceProbs) {
        return this.selectPlan(null, plans, choiceProbs);
    }

    protected int selectPlan(Integer overrideChoice, List<? extends Plan<L>> plans, Vector choiceProbs) {
        if (plans == null) {
            throw new IllegalArgumentException("plans list ist null");
        }
        if (plans.size() == 0) {
            throw new IllegalArgumentException("plans list is empty");
        }
        if (choiceProbs == null) {
            throw new IllegalArgumentException("choice probability list is null");
        }
        if (choiceProbs.size() == 0) {
            throw new IllegalArgumentException("choice probability list is empty");
        }
        if (plans.size() != choiceProbs.size()) {
            throw new IllegalArgumentException("plans list has " + plans.size() + " elements, but choice probability list has " + choiceProbs.size() + " elements");
        }
        if (overrideChoice != null && (overrideChoice < 0 || overrideChoice >= plans.size())) {
            throw new IllegalArgumentException("overriding choice " + overrideChoice + "is not in {0,...," + (plans.size() - 1) + "}");
        }
        if (this.bruteForce) {
            ArrayList<Integer> bestIndices = new ArrayList<Integer>(plans.size());
            double bestLambda = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < plans.size(); ++i) {
                double lambda = this.calcLinearPlanEffect(plans.get(i));
                if (lambda > bestLambda) {
                    bestIndices.clear();
                    bestIndices.add(i);
                    bestLambda = lambda;
                    continue;
                }
                if (lambda != bestLambda) continue;
                bestIndices.add(i);
            }
            this.lastChoiceProbs = new Vector(plans.size());
            for (Integer index : bestIndices) {
                this.lastChoiceProbs.set(index, Math.max(1.0E-6, choiceProbs.get(index)));
            }
        } else {
            this.lastChoiceProbs = choiceProbs.copy();
            Vector lambdas = new Vector(plans.size());
            for (int i = 0; i < plans.size(); ++i) {
                lambdas.set(i, this.calcLinearPlanEffect(plans.get(i)));
            }
            double maxLambda = lambdas.max();
            for (int i = 0; i < plans.size(); ++i) {
                this.lastChoiceProbs.mult(i, Math.exp(lambdas.get(i) - maxLambda));
                this.lastChoiceProbs.set(i, Math.max(1.0E-6, this.lastChoiceProbs.get(i)));
            }
        }
        this.lastChoiceProbs.mult(1.0 / this.lastChoiceProbs.sum());
        this.lastChoiceIndex = overrideChoice == null ? MathHelpers.draw(this.lastChoiceProbs, this.getRandom()) : overrideChoice;
        this.addToDemand(plans.get(this.getLastChoiceIndex()));
        return this.getLastChoiceIndex();
    }
}

