/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.calibrators.filebased;

import floetteroed.cadyts.calibrators.Calibrator;
import floetteroed.cadyts.calibrators.analytical.AnalyticalCalibrator;
import floetteroed.cadyts.calibrators.filebased.Agent;
import floetteroed.cadyts.calibrators.filebased.ChoiceFileWriter;
import floetteroed.cadyts.calibrators.filebased.PopulationFileReader;
import floetteroed.cadyts.demand.Plan;
import floetteroed.cadyts.demand.PlanChoiceModel;
import floetteroed.cadyts.measurements.SingleLinkMeasurement;
import floetteroed.utilities.commandlineparser.CommandLineParser;
import floetteroed.utilities.commandlineparser.CommandLineParserElement;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.logging.Logger;

public abstract class FileBasedController<C extends AnalyticalCalibrator<L>, A extends Agent<P, ? extends PlanChoiceModel<P>>, P extends Plan<L>, L> {
    public static final String FILENAME_SEPARATOR_REGEX = "\\,";
    public static final String SERIALIZED_FILE = "serialized.bin";
    public static final String INIT = "INIT";
    public static final String MEASFILE_KEY = "-measfile";
    public static final String LOGFILE_KEY = "-logfile";
    public static final String RNDSEED_KEY = "-rndseed";
    public static final String BINSIZE_KEY = "-binsize";
    public static final String REGRINERTIA_KEY = "-regrinertia";
    public static final String FREEZEIT_KEY = "-freezeit";
    public static final String VARSCALE_KEY = "-varscale";
    public static final String MINFLOWSTDDEV_KEY = "-minflowstddev";
    public static final String MINCOUNTSTDDEV_KEY = "-mincountstddev";
    public static final String PREPITS_KEY = "-prepits";
    public static final String CENTERREGR_KEY = "-centerregr";
    public static final String STATSFILE_KEY = "-statsfile";
    public static final String PROPASSIGN_KEY = "-propassign";
    public static final String CNTFIRSTLINK_KEY = "-cntfirstlink";
    public static final String CNTLASTLINK_KEY = "-cntlastlink";
    public static final String DEBUGMODE_KEY = "-debug";
    public static final String BRUTEFORCE_KEY = "-bruteforce";
    public static final String UPDATE = "UPDATE";
    public static final String CHOICESETFILE_KEY = "-choicesetfile";
    public static final String CHOICEFILE_KEY = "-choicefile";
    public static final String CHOICE = "CHOICE";
    public static final String NETFILE_KEY = "-netfile";
    public static final String FLOWFILE_KEY = "-flowfile";

    protected FileBasedController() {
    }

    protected void init(String[] args) throws IOException {
        CommandLineParser clp = new CommandLineParser();
        this.prepareCommandLineParserINIT(clp);
        clp.parse(args);
        if (!clp.isComplete()) {
            this.exitWithParameterList(clp, INIT);
        }
        C calibrator = this.newCalibrator(clp);
        this.prepareCalibratorINIT(calibrator, clp);
        for (String measFile : clp.getString(MEASFILE_KEY).split(FILENAME_SEPARATOR_REGEX)) {
            if (measFile == null || "".equals(measFile)) continue;
            Logger.getLogger(this.getClass().getName()).info("loading measurement file " + measFile);
            this.loadMeasurements(calibrator, measFile);
        }
        this.serialize(calibrator);
    }

    protected abstract C newCalibrator(CommandLineParser var1);

    protected void prepareCommandLineParserINIT(CommandLineParser clp) {
        clp.defineParameter(LOGFILE_KEY, false, null, "logfile");
        clp.defineParameter(MEASFILE_KEY, true, null, "comma-separated list of files that contain the measurements");
        clp.defineParameter(BINSIZE_KEY, true, null, "numerical bin size [s]");
        clp.defineParameter(RNDSEED_KEY, false, Long.toString(0L), "random seed");
        clp.defineParameter(VARSCALE_KEY, false, Double.toString(1.0), "scales measurement variance");
        clp.defineParameter(REGRINERTIA_KEY, false, Double.toString(0.95), "regression inertia");
        clp.defineParameter(FREEZEIT_KEY, false, Integer.toString(Integer.MAX_VALUE), "number of iterations until system freezes");
        clp.defineParameter(MINFLOWSTDDEV_KEY, false, Double.toString(25.0), "minimum flow standard deviation [veh/h]");
        clp.defineParameter(MINCOUNTSTDDEV_KEY, false, Double.toString(25.0), "minimum count standard deviation [veh]");
        clp.defineParameter(PREPITS_KEY, false, Integer.toString(1), "number of preparatory iterations");
        clp.defineParameter(CENTERREGR_KEY, false, Boolean.toString(false), "centering of internal regressions");
        clp.defineParameter(STATSFILE_KEY, false, "calibration-stats.txt", "name of file where statistics are written");
        clp.defineParameter(PROPASSIGN_KEY, false, Boolean.toString(false), "if the calibration is to use a proportional assignment");
        clp.defineParameter(CNTFIRSTLINK_KEY, false, Boolean.toString(false), "if entering vehicles are assumed to cross the upstream sensor of their entry link");
        clp.defineParameter(CNTLASTLINK_KEY, false, Boolean.toString(true), "if exiting vehicles are assumed to cross the upstream sensor of their exit link");
        clp.defineParameter(DEBUGMODE_KEY, false, Boolean.toString(false), "if fine-grained debug messages are to be generated");
        clp.defineParameter(BRUTEFORCE_KEY, false, Boolean.toString(false), "enforces best effort in measurement reproduction");
    }

    protected void prepareCalibratorINIT(C calibrator, CommandLineParser clp) {
        ((Calibrator)calibrator).setRegressionInertia(clp.getDouble(REGRINERTIA_KEY));
        ((Calibrator)calibrator).setVarianceScale(clp.getDouble(VARSCALE_KEY));
        ((Calibrator)calibrator).setFreezeIteration(clp.getInteger(FREEZEIT_KEY));
        ((Calibrator)calibrator).setMinStddev(clp.getDouble(MINFLOWSTDDEV_KEY), SingleLinkMeasurement.TYPE.FLOW_VEH_H);
        ((Calibrator)calibrator).setMinStddev(clp.getDouble(MINCOUNTSTDDEV_KEY), SingleLinkMeasurement.TYPE.COUNT_VEH);
        ((Calibrator)calibrator).setPreparatoryIterations(clp.getInteger(PREPITS_KEY));
        ((Calibrator)calibrator).setCenterRegression(clp.getBoolean(CENTERREGR_KEY));
        ((Calibrator)calibrator).setStatisticsFile(clp.getString(STATSFILE_KEY));
        ((Calibrator)calibrator).setProportionalAssignment(clp.getBoolean(PROPASSIGN_KEY));
        ((Calibrator)calibrator).setCountFirstLink(clp.getBoolean(CNTFIRSTLINK_KEY));
        ((Calibrator)calibrator).setCountLastLink(clp.getBoolean(CNTLASTLINK_KEY));
        ((Calibrator)calibrator).setDebugMode(clp.getBoolean(DEBUGMODE_KEY));
        ((AnalyticalCalibrator)calibrator).setBruteForce(clp.getBoolean(BRUTEFORCE_KEY));
    }

    protected abstract void loadMeasurements(C var1, String var2);

    protected void choice(String[] args) throws IOException, ClassNotFoundException {
        CommandLineParser clp = new CommandLineParser();
        this.prepareCommandLineParserCHOICE(clp);
        clp.parse(args);
        if (!clp.isComplete()) {
            this.exitWithParameterList(clp, CHOICE);
        }
        C calibrator = this.deserialize();
        this.prepareCalibratorCHOICE(calibrator, clp);
        this.selectPlans(calibrator, clp);
        this.serialize(calibrator);
    }

    protected void prepareCommandLineParserCHOICE(CommandLineParser clp) {
        clp.defineParameter(CHOICESETFILE_KEY, true, null, "comma-separated list of files that contain the choice sets");
        clp.defineParameter(CHOICEFILE_KEY, true, null, "fine where the choices are to be written");
    }

    protected void prepareCalibratorCHOICE(C calibrator, CommandLineParser clp) {
    }

    protected void selectPlans(C calibrator, CommandLineParser clp) throws IOException {
        PopulationFileReader<A> popFileReader = this.newPopulationReader(calibrator, clp);
        ChoiceFileWriter<Agent, Plan> choiceFileWriter = this.newChoiceFileWriter(calibrator);
        if (popFileReader == null) {
            throw new NullPointerException("population file reader is null");
        }
        if (choiceFileWriter == null) {
            throw new NullPointerException("choice file writer is null");
        }
        String choiceFile = clp.getString(CHOICEFILE_KEY);
        choiceFileWriter.open(choiceFile);
        Logger.getLogger(this.getClass().getName()).info("creating choice file " + choiceFile);
        for (String popFile : clp.getString(CHOICESETFILE_KEY).split(FILENAME_SEPARATOR_REGEX)) {
            if (popFile == null || "".equals(popFile)) continue;
            Logger.getLogger(this.getClass().getName()).info("loading choice set file " + popFile);
            for (Agent agent : popFileReader.getPopulationSource(popFile)) {
                this.beforeChoice(calibrator, agent);
                List plans = agent.getPlans();
                int planIndex = ((AnalyticalCalibrator)calibrator).selectPlan(plans, agent.getPlanChoiceModel().getChoiceProbabilities(plans));
                Plan plan = (Plan)plans.get(planIndex);
                this.afterChoice(calibrator, agent, plan);
                choiceFileWriter.write(agent, plan);
            }
        }
        choiceFileWriter.close();
    }

    protected abstract PopulationFileReader<A> newPopulationReader(C var1, CommandLineParser var2);

    protected abstract ChoiceFileWriter<A, P> newChoiceFileWriter(C var1);

    protected void beforeChoice(C calibrator, A agent) {
    }

    protected void afterChoice(C calibrator, A agent, P plan) {
    }

    protected void update(String[] args) throws IOException, ClassNotFoundException {
        CommandLineParser clp = new CommandLineParser();
        this.prepareCommandLineParserUPDATE(clp);
        clp.parse(args);
        if (!clp.isComplete()) {
            this.exitWithParameterList(clp, UPDATE);
        }
        C calibrator = this.deserialize();
        this.prepareCalibratorUPDATE(calibrator, clp);
        this.update(calibrator, clp);
        this.serialize(calibrator);
    }

    protected void prepareCommandLineParserUPDATE(CommandLineParser clp) {
        clp.defineParameter(NETFILE_KEY, true, null, "file that contains the network conditions");
        clp.defineParameter(FLOWFILE_KEY, false, null, "file in which to write comparisons of measured and simulated flows");
    }

    protected void prepareCalibratorUPDATE(C calibrator, CommandLineParser clp) {
    }

    protected abstract void update(C var1, CommandLineParser var2);

    protected void serialize(C calibrator) throws IOException {
        Logger.getLogger(this.getClass().getName()).info("serializing to file serialized.bin");
        FileOutputStream fos = new FileOutputStream(SERIALIZED_FILE);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(calibrator);
        out.flush();
        out.close();
    }

    protected C deserialize() throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(SERIALIZED_FILE);
        ObjectInputStream in = new ObjectInputStream(fis);
        AnalyticalCalibrator result = (AnalyticalCalibrator)in.readObject();
        Logger.getLogger(this.getClass().getName()).info("deserialized from file serialized.bin");
        return (C)result;
    }

    protected void exitWithGeneralHelp() {
        System.err.println("Calibration: Unknown parameters. For help, call with single parameter INIT, CHOICE or UPDATE.");
        System.exit(-1);
    }

    protected void exitWithParameterList(CommandLineParser clp, String phase) {
        System.err.println("Use the following command line parameters for " + phase + " :");
        for (CommandLineParserElement element : clp.getElements()) {
            System.err.println(element);
        }
        System.exit(-1);
    }

    public void run(String[] args) throws IOException, ClassNotFoundException {
        if (args == null || args.length == 0) {
            this.exitWithGeneralHelp();
        } else {
            String action = args[0];
            String[] params = new String[args.length - 1];
            System.arraycopy(args, 1, params, 0, args.length - 1);
            if (INIT.equalsIgnoreCase(action)) {
                this.init(params);
            } else if (CHOICE.equalsIgnoreCase(action)) {
                this.choice(params);
            } else if (UPDATE.equalsIgnoreCase(action)) {
                this.update(params);
            } else {
                this.exitWithGeneralHelp();
            }
        }
    }
}

