/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.calibrators.sampling;

import floetteroed.cadyts.calibrators.sampling.ChoiceSampler;
import floetteroed.cadyts.calibrators.sampling.SamplingCalibrator;
import floetteroed.cadyts.demand.Plan;
import floetteroed.cadyts.demand.PlanStep;
import floetteroed.utilities.math.PolynomialTrendFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class RecursiveSampler<L>
implements ChoiceSampler<L> {
    private final SamplingCalibrator<L> calibrator;
    private final PolynomialTrendFilter likelihoodTrendFilter;
    private final Map<Iterable<PlanStep<L>>, Double> plan2linEffect = new HashMap<Iterable<PlanStep<L>>, Double>();
    private int draws = 0;
    private double likelihoodSum = 0.0;
    private boolean acceptNext = false;

    public RecursiveSampler(SamplingCalibrator<L> calibrator) {
        if (calibrator == null) {
            throw new IllegalArgumentException("calibrator is null");
        }
        this.calibrator = calibrator;
        this.likelihoodTrendFilter = new PolynomialTrendFilter(calibrator.getRegressionInertia(), 1);
        this.init();
    }

    private void init() {
        this.likelihoodTrendFilter.setLambda(this.calibrator.getRegressionInertia());
        this.plan2linEffect.clear();
        this.draws = 0;
        this.likelihoodSum = 0.0;
        this.acceptNext = false;
    }

    public double getPredictedLikelihood() {
        return this.likelihoodTrendFilter.predict(1);
    }

    PolynomialTrendFilter getLikelihoodTrendFilter() {
        return this.likelihoodTrendFilter;
    }

    private double likelihood(Plan<L> plan) {
        Double linEffect = this.plan2linEffect.get(plan);
        if (linEffect == null) {
            linEffect = this.calibrator.calcLinearPlanEffect(plan);
            this.plan2linEffect.put(plan, linEffect);
        }
        return Math.exp(linEffect);
    }

    @Override
    public void enforceNextAccept() {
        this.acceptNext = true;
    }

    @Override
    public boolean isAccepted(Plan<L> plan) {
        boolean isAccepted;
        ++this.draws;
        double likelihood = this.likelihood(plan);
        boolean infiniteLikelihood = Double.isInfinite(likelihood);
        if (!infiniteLikelihood) {
            this.likelihoodSum += likelihood;
        }
        if (this.acceptNext) {
            isAccepted = true;
        } else if (infiniteLikelihood) {
            isAccepted = true;
            Logger.getLogger(this.getClass().getName()).warning("infinite likelihood numerator");
        } else {
            double pAccept = likelihood / (likelihood + (double)(this.calibrator.getMaxDraws() - this.draws) * this.likelihoodTrendFilter.predict(1));
            boolean bl = isAccepted = this.calibrator.getRandom().nextDouble() < pAccept;
        }
        if (isAccepted || this.calibrator.getMaxDraws() == this.draws) {
            if (!isAccepted) {
                Logger.getLogger(this.getClass().getName()).warning("no accept after maximum number of draws");
            }
            if (infiniteLikelihood) {
                --this.draws;
            }
            if (this.draws > 0) {
                this.likelihoodTrendFilter.add(this.likelihoodSum / (double)this.draws);
            }
            this.calibrator.addToDemand(plan);
            this.init();
        }
        return isAccepted;
    }
}

