/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.interfaces.sumo;

import floetteroed.cadyts.calibrators.analytical.AnalyticalCalibrator;
import floetteroed.utilities.DynamicData;
import java.util.logging.Logger;

class SumoCalibrator
extends AnalyticalCalibrator<String> {
    private static final long serialVersionUID = 1L;
    static final double DEFAULT_DEMAND_SCALE = 1.0;
    static final boolean DEFAULT_OVERRIDE_TRAVELTIMES = false;
    static final String DEFAULT_FMA_PREFIX = null;
    static final String DEFAULT_CLONE_POSTFIX = "-CLONE";
    private double demandScale = 1.0;
    private boolean overrideTravelTimes = false;
    private DynamicData<String> travelTimes;
    private String fmaPrefix = DEFAULT_FMA_PREFIX;
    private String clonePostfix = "-CLONE";

    SumoCalibrator(String logFile, Long randomSeed, int binSize_s) {
        super(logFile, randomSeed, binSize_s);
        Logger.getLogger(this.myName).info("default demandScale is " + this.demandScale);
        Logger.getLogger(this.myName).info("default overrideTravelTimes is " + this.overrideTravelTimes);
        Logger.getLogger(this.myName).info("default fmaPrefix is " + this.fmaPrefix);
        Logger.getLogger(this.myName).info("default clonePostfix is " + this.clonePostfix);
    }

    void setDemandScale(double demandScale) {
        if (demandScale < 1.0) {
            throw new IllegalArgumentException("demandScale must not be smaller than one");
        }
        this.demandScale = demandScale;
        Logger.getLogger(this.getClass().getName()).info("set demandScale to " + this.demandScale);
    }

    double getDemandScale() {
        return this.demandScale;
    }

    void setOverrideTravelTimes(boolean overrideTravelTimes) {
        this.overrideTravelTimes = overrideTravelTimes;
        Logger.getLogger(this.myName).info("set overrideTravelTimes to " + this.overrideTravelTimes);
    }

    boolean getOverrideTravelTimes() {
        return this.overrideTravelTimes;
    }

    void overrideTravelTimes(DynamicData<String> travelTimes) {
        if (!this.overrideTravelTimes) {
            Logger.getLogger(this.myName).warning("ignoring call to overrideTravelTimes(..)");
            return;
        }
        if (this.travelTimes == null) {
            this.travelTimes = travelTimes;
        } else {
            this.travelTimes.overrideWithNonZeros(travelTimes);
        }
        Logger.getLogger(this.myName).fine("overrode travelTimes");
    }

    DynamicData<String> getTravelTimes() {
        return this.travelTimes;
    }

    void setFmaPrefix(String fmaPrefix) {
        this.fmaPrefix = fmaPrefix;
        Logger.getLogger(this.myName).info("set fmaPrefix to " + this.fmaPrefix);
    }

    String getFmaPrefix() {
        return this.fmaPrefix;
    }

    void setClonePostfix(String clonePostfix) {
        if (clonePostfix == null) {
            throw new IllegalArgumentException("clonePostfix is null");
        }
        this.clonePostfix = clonePostfix;
        Logger.getLogger(this.myName).info("set clonePostfix to " + this.clonePostfix);
    }

    String getClonePostfix() {
        return this.clonePostfix;
    }
}

