/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.interfaces.sumo;

import floetteroed.cadyts.calibrators.filebased.ChoiceFileWriter;
import floetteroed.cadyts.demand.PlanStep;
import floetteroed.cadyts.interfaces.sumo.SumoAgent;
import floetteroed.cadyts.interfaces.sumo.SumoPlan;
import floetteroed.utilities.Tuple;
import floetteroed.utilities.XMLHelpers;
import java.io.IOException;
import java.io.PrintWriter;

public class SumoChoiceWriter
implements ChoiceFileWriter<SumoAgent, SumoPlan> {
    private static final long serialVersionUID = 1L;
    static final String ROUTE_ALTERNATIVES = "route-alternatives";
    private transient PrintWriter writer = null;

    SumoChoiceWriter() {
    }

    @Override
    public void open(String choiceFile) throws IOException {
        this.writer = new PrintWriter(choiceFile);
        this.writer.write("<");
        this.writer.write(ROUTE_ALTERNATIVES);
        this.writer.write(">");
        this.writer.println();
    }

    @Override
    public void write(SumoAgent agent, SumoPlan plan) throws IOException {
        if (plan.isStayAtHome()) {
            return;
        }
        this.writer.write("<");
        this.writer.write("vehicle");
        this.writer.write(" ");
        XMLHelpers.writeAttr("id", agent.getId(), this.writer);
        XMLHelpers.writeAttr("depart", agent.getDptTime_s(), this.writer);
        if (agent.getODRelation() != null) {
            XMLHelpers.writeAttr("fromtaz", agent.getODRelation().getFromTAZ(), this.writer);
            XMLHelpers.writeAttr("totaz", agent.getODRelation().getToTAZ(), this.writer);
        }
        if (agent.getMiscAttrs() != null) {
            for (Tuple<String, String> miscAttr : agent.getMiscAttrs()) {
                XMLHelpers.writeAttr(miscAttr.getA(), miscAttr.getB(), this.writer);
            }
        }
        this.writer.write(">");
        this.writer.println();
        StringBuffer edges = new StringBuffer();
        StringBuffer exits = new StringBuffer();
        String lastLink = plan.getStartLink();
        for (PlanStep planStep : plan.getPlan4fileDump()) {
            edges.append(lastLink);
            edges.append(" ");
            exits.append(planStep.getEntryTime_s());
            exits.append(" ");
            lastLink = (String)planStep.getLink();
        }
        edges.append(lastLink);
        exits.append(plan.getExitTime_s());
        this.writer.write("  <");
        this.writer.write("route");
        this.writer.write(" ");
        XMLHelpers.writeAttr("edges", edges.toString(), this.writer);
        XMLHelpers.writeAttr("exitTimes", exits.toString(), this.writer);
        XMLHelpers.writeAttr("probability", "1", this.writer);
        this.writer.write("/>");
        this.writer.println();
        this.writer.write("</");
        this.writer.write("vehicle");
        this.writer.write(">");
        this.writer.println();
    }

    @Override
    public void close() throws IOException {
        this.writer.write("</");
        this.writer.write(ROUTE_ALTERNATIVES);
        this.writer.write(">");
        this.writer.println();
        this.writer.flush();
        this.writer.close();
    }
}

