/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.supply;

import floetteroed.cadyts.measurements.SingleLinkMeasurement;
import floetteroed.cadyts.supply.SimResults;
import floetteroed.utilities.DynamicData;
import java.util.HashMap;
import java.util.Map;

public class BasicSimResults<L>
implements SimResults<L> {
    private static final long serialVersionUID = 1L;
    private final Map<SingleLinkMeasurement.TYPE, DynamicData<L>> contents = new HashMap<SingleLinkMeasurement.TYPE, DynamicData<L>>(SingleLinkMeasurement.TYPE.values().length);

    public BasicSimResults(int startTime_s, int binSize_s, int binCnt) {
        for (SingleLinkMeasurement.TYPE type : SingleLinkMeasurement.TYPE.values()) {
            this.contents.put(type, new DynamicData(startTime_s, binSize_s, binCnt));
        }
    }

    public DynamicData<L> getSimResults(SingleLinkMeasurement.TYPE type) {
        return this.contents.get((Object)type);
    }

    @Override
    public double getSimValue(L link, int startTime_s, int endTime_s, SingleLinkMeasurement.TYPE type) {
        if (type == null) {
            throw new IllegalArgumentException("measurement type must not be null");
        }
        if (SingleLinkMeasurement.TYPE.FLOW_VEH_H.equals((Object)type)) {
            return this.getSimResults(type).getAverage(link, startTime_s, endTime_s);
        }
        if (SingleLinkMeasurement.TYPE.COUNT_VEH.equals((Object)type)) {
            return this.getSimResults(type).getSum(link, startTime_s, endTime_s);
        }
        throw new IllegalArgumentException("unknown measurement type " + type + " -- this should not happen");
    }
}

