/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.supply;

import floetteroed.cadyts.calibrators.TimedElement;
import floetteroed.cadyts.demand.Demand;
import floetteroed.cadyts.demand.Plan;
import floetteroed.cadyts.supply.LinkLoading;
import floetteroed.utilities.math.Regression;
import floetteroed.utilities.math.Vector;
import java.util.HashSet;
import java.util.Set;

public class LinkLoadingLocal<L>
extends TimedElement
implements LinkLoading<L> {
    private static final long serialVersionUID = 1L;
    private final L link;
    private final Regression regression;
    private int iteration = 0;
    private static final int DEMAND_INDEX = 0;
    private static final int OFFSET_INDEX = 1;
    private final Vector regrInput = new Vector(2);

    public LinkLoadingLocal(L link, int startTime_s, int endTime_s, double regressionInertia, boolean centerRegression) {
        super(startTime_s, endTime_s);
        if (link == null) {
            throw new IllegalArgumentException("link must not be null");
        }
        this.link = link;
        this.regression = new Regression(regressionInertia, 2);
        if (centerRegression) {
            this.regression.enableInputCentering(0);
        }
    }

    private Vector regrInput(Demand<L> demand) {
        this.regrInput.set(0, demand.getSum(this.getLink(), this.getStartTime_s(), this.getEndTime_s()));
        this.regrInput.set(1, 1.0);
        return this.regrInput;
    }

    @Override
    public L getLink() {
        return this.link;
    }

    @Override
    public Set<L> getRelevantLinks() {
        HashSet<L> result = new HashSet<L>();
        result.add(this.getLink());
        return result;
    }

    @Override
    public void freeze() {
        this.regression.setInertia(1.0);
    }

    @Override
    public double getRegressionInertia() {
        return this.regression.getInertia();
    }

    @Override
    public double get_dLinkFeature_dDemand(L link) {
        if (!this.isPlanListening() && this.link.equals(link)) {
            return this.regression.getCoefficients().get(0);
        }
        return 0.0;
    }

    @Override
    public void update(Demand<L> demand, double linkFeature) {
        ++this.iteration;
        this.regression.update(this.regrInput(demand), linkFeature);
    }

    @Override
    public double predictLinkFeature(Demand<L> demand) {
        return this.regression.predict(this.regrInput(demand));
    }

    @Override
    public boolean isPlanListening() {
        return this.iteration < 5;
    }

    @Override
    public void notifyPlanChoice(Plan<L> plan) {
    }
}

