/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities;

import java.util.ArrayList;
import java.util.List;

public class Discretizer {
    private Discretizer() {
    }

    public static List<Double> interpolateOrder0(List<Double> times_s, List<Double> values, double startTime_s, double binSize_s, int binCnt) {
        return Discretizer.interpolate(times_s, values, startTime_s, binSize_s, binCnt, false);
    }

    public static List<Double> interpolateOrder1(List<Double> times_s, List<Double> values, double startTime_s, double binSize_s, int binCnt) {
        return Discretizer.interpolate(times_s, values, startTime_s, binSize_s, binCnt, true);
    }

    private static List<Double> interpolate(List<Double> times_s, List<Double> values, double startTime_s, double binSize_s, int binCnt, boolean interpolatePoints) {
        if (times_s == null || times_s.size() == 0) {
            throw new IllegalArgumentException("list of times is null or empty");
        }
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException("list of values is null or empty");
        }
        if (times_s.size() != values.size()) {
            throw new IllegalArgumentException("list sizes of times and values do not match: " + times_s.size() + " vs. " + values.size());
        }
        ArrayList<Double> result = new ArrayList<Double>(binCnt);
        int nextIndex = 0;
        for (int bin = 0; bin < binCnt; ++bin) {
            double currentTime_s = startTime_s + (double)bin * binSize_s;
            while (times_s.get(nextIndex) < currentTime_s && nextIndex < times_s.size() - 1) {
                ++nextIndex;
            }
            if (times_s.size() == 1 || nextIndex == 0 || times_s.get(nextIndex) < currentTime_s) {
                result.add(values.get(nextIndex));
                continue;
            }
            double w = interpolatePoints ? (times_s.get(nextIndex) - currentTime_s) / (times_s.get(nextIndex) - times_s.get(nextIndex - 1)) : 1.0;
            result.add(w * values.get(nextIndex - 1) + (1.0 - w) * values.get(nextIndex));
        }
        return result;
    }
}

