/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities;

import floetteroed.utilities.TimeDiscretization;
import floetteroed.utilities.math.MathHelpers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DynamicData<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int startTime_s;
    private final int binSize_s;
    private int binCnt;
    protected final Map<K, double[]> data = new HashMap<K, double[]>();

    public DynamicData(int startTime_s, int binSize_s, int binCnt) {
        if (binSize_s <= 0) {
            throw new IllegalArgumentException("binSize_s must be strictly positive");
        }
        if (binCnt <= 0) {
            throw new IllegalArgumentException("binCnt must be strictly positive");
        }
        this.startTime_s = startTime_s;
        this.binSize_s = binSize_s;
        this.binCnt = binCnt;
    }

    public DynamicData(TimeDiscretization timeDiscr) {
        this(timeDiscr.getStartTime_s(), timeDiscr.getBinSize_s(), timeDiscr.getBinCnt());
    }

    public int getStartTime_s() {
        return this.startTime_s;
    }

    public int getBinSize_s() {
        return this.binSize_s;
    }

    public int getBinCnt() {
        return this.binCnt;
    }

    public int bin(int time_s) {
        return (time_s - this.startTime_s) / this.binSize_s;
    }

    public int binStart_s(int bin) {
        return this.startTime_s + bin * this.binSize_s;
    }

    protected double[] getNonNullDataArray(K key) {
        double[] dataArray = this.data.get(key);
        if (dataArray == null) {
            dataArray = new double[this.getBinCnt()];
            this.data.put(key, dataArray);
        }
        return dataArray;
    }

    public void put(K key, int bin, double value) {
        this.getNonNullDataArray(key)[bin] = value;
    }

    public void add(K key, int bin, double value) {
        double[] dArray = this.getNonNullDataArray(key);
        int n = bin;
        dArray[n] = dArray[n] + value;
    }

    public void clear() {
        this.data.clear();
    }

    public Set<K> keySet() {
        return this.data.keySet();
    }

    public double getBinValue(K key, int bin) {
        double[] dataArray = this.data.get(key);
        if (dataArray == null) {
            return 0.0;
        }
        return dataArray[bin];
    }

    public double getSum(K key, int startTime_s, int endTime_s) {
        double[] dataArray = this.data.get(key);
        if (dataArray == null) {
            return 0.0;
        }
        int startBin = Math.max(this.bin(startTime_s), 0);
        int endBin = Math.min(this.bin(endTime_s - 1), this.getBinCnt() - 1);
        double result = 0.0;
        for (int bin = startBin; bin <= endBin; ++bin) {
            double weight = MathHelpers.overlap(this.binStart_s(bin), this.binStart_s(bin) + this.getBinSize_s(), startTime_s, endTime_s) / (double)this.getBinSize_s();
            result += weight * dataArray[bin];
        }
        return result;
    }

    public double getAverage(K key, int startTime_s, int endTime_s) {
        double binCnt = (double)(endTime_s - startTime_s) / (double)this.getBinSize_s();
        return this.getSum(key, startTime_s, endTime_s) / binCnt;
    }

    public void overrideWithNonZeros(DynamicData<K> source) {
        for (Map.Entry<K, double[]> sourceEntry : source.data.entrySet()) {
            K key = sourceEntry.getKey();
            double[] newValue = MathHelpers.override(this.data.get(key), sourceEntry.getValue(), false);
            this.data.put(key, newValue);
        }
    }

    public void resize(int newBinCnt) {
        if (newBinCnt == this.binCnt) {
            return;
        }
        if (newBinCnt <= 0) {
            throw new IllegalArgumentException("binCnt must be strictly positive");
        }
        ArrayList<K> allKeys = new ArrayList<K>(this.data.keySet());
        for (Object key : allKeys) {
            double[] oldArray = this.data.get(key);
            if (oldArray == null) continue;
            double[] newArray = new double[newBinCnt];
            System.arraycopy(oldArray, 0, newArray, 0, Math.min(this.binCnt, newBinCnt));
            this.data.put(key, newArray);
        }
        this.binCnt = newBinCnt;
    }

    public double sumOfEntries2() {
        double result = 0.0;
        for (double[] array : this.data.values()) {
            for (double val : array) {
                result += val * val;
            }
        }
        return result;
    }
}

