/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities;

import floetteroed.utilities.DynamicData;
import floetteroed.utilities.SetUtils;

public class DynamicDataUtils {
    private DynamicDataUtils() {
    }

    public static <L> double sumOfEntries2(DynamicData<L> data) {
        double result = 0.0;
        for (L locObj : data.keySet()) {
            for (int bin = 0; bin < data.getBinCnt(); ++bin) {
                double val = data.getBinValue(locObj, bin);
                result += val * val;
            }
        }
        return result;
    }

    public static <L> double sumOfDifferences2(DynamicData<L> counts1, DynamicData<L> counts2) {
        if (counts1.getBinCnt() != counts2.getBinCnt()) {
            throw new RuntimeException("arg1 has " + counts1.getBinCnt() + " bins, but arg2 has " + counts2.getBinCnt() + " bins.");
        }
        double result = 0.0;
        for (L locObj : SetUtils.union(counts1.keySet(), counts2.keySet())) {
            for (int bin = 0; bin < counts1.getBinCnt(); ++bin) {
                double diff = counts1.getBinValue(locObj, bin) - counts2.getBinValue(locObj, bin);
                result += diff * diff;
            }
        }
        return result;
    }

    public static <L> DynamicData<L> newDifference(DynamicData<L> data1, DynamicData<L> data2, double weight) {
        if (data1.getBinCnt() != data2.getBinCnt()) {
            throw new RuntimeException("arg1 has " + data1.getBinCnt() + " bins, but arg2 has " + data2.getBinCnt() + " bins.");
        }
        DynamicData<L> result = new DynamicData<L>(data1.getStartTime_s(), data1.getBinSize_s(), data1.getBinCnt());
        for (L locObj : SetUtils.union(data1.keySet(), data2.keySet())) {
            for (int bin = 0; bin < data1.getBinCnt(); ++bin) {
                result.put(locObj, bin, weight * (data1.getBinValue(locObj, bin) - data2.getBinValue(locObj, bin)));
            }
        }
        return result;
    }

    public static <L> DynamicData<L> newWeightedSum(DynamicData<L> data1, double weight1, DynamicData<L> data2, double weight2) {
        if (data1.getBinCnt() != data2.getBinCnt()) {
            throw new RuntimeException("arg1 has " + data1.getBinCnt() + " bins, but arg2 has " + data2.getBinCnt() + " bins.");
        }
        DynamicData<L> result = new DynamicData<L>(data1.getStartTime_s(), data1.getBinSize_s(), data1.getBinCnt());
        for (L locObj : SetUtils.union(data1.keySet(), data2.keySet())) {
            for (int bin = 0; bin < data1.getBinCnt(); ++bin) {
                result.put(locObj, bin, weight1 * data1.getBinValue(locObj, bin) + weight2 * data2.getBinValue(locObj, bin));
            }
        }
        return result;
    }

    public static <L> double innerProduct(DynamicData<L> data1, DynamicData<L> data2) {
        if (data1.getBinCnt() != data2.getBinCnt()) {
            throw new RuntimeException("arg1 has " + data1.getBinCnt() + " bins, but arg2 has " + data2.getBinCnt() + " bins.");
        }
        double result = 0.0;
        for (L locObj : SetUtils.union(data1.keySet(), data2.keySet())) {
            for (int bin = 0; bin < data1.getBinCnt(); ++bin) {
                result += data1.getBinValue(locObj, bin) * data2.getBinValue(locObj, bin);
            }
        }
        return result;
    }
}

