/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class IdentifiedElementParser
extends DefaultHandler {
    private final String element;
    private final String idAttribute;
    private Map<String, Attributes> id2attrs = null;

    public IdentifiedElementParser(String element, String idAttribute) {
        if (element == null || "".equals(element)) {
            throw new IllegalArgumentException("element is " + idAttribute + ".");
        }
        this.element = element;
        this.idAttribute = idAttribute;
    }

    public Map<String, Attributes> readId2AttrsMap(String fileName) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setContentHandler(this);
            reader.parse(fileName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.id2attrs;
    }

    @Override
    public void startDocument() {
        this.id2attrs = new HashMap<String, Attributes>();
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (this.element.equals(qName)) {
            if (this.idAttribute == null) {
                this.id2attrs.put(Integer.toString(this.id2attrs.size()), new AttributesImpl(attrs));
            } else {
                String id = attrs.getValue(this.idAttribute);
                AttributesImpl attrsCopy = new AttributesImpl(attrs);
                this.id2attrs.put(id, attrsCopy);
            }
        }
    }
}

