/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities;

import floetteroed.utilities.Time;

public class TimeDiscretization {
    private final int startTime_s;
    private final int binSize_s;
    private final int binCnt;

    public TimeDiscretization(int startTime_s, int binSize_s, int binCnt) {
        this.startTime_s = startTime_s;
        this.binSize_s = binSize_s;
        this.binCnt = binCnt;
    }

    public int getStartTime_s() {
        return this.startTime_s;
    }

    public int getBinSize_s() {
        return this.binSize_s;
    }

    public int getBinCnt() {
        return this.binCnt;
    }

    public int getBin(double time_s) {
        return (int)((time_s - (double)this.startTime_s) / (double)this.binSize_s);
    }

    public int getBinStartTime_s(int bin) {
        return this.startTime_s + bin * this.binSize_s;
    }

    public int getBinCenterTime_s(int bin) {
        return this.getBinStartTime_s(bin) + this.binSize_s / 2;
    }

    public int getBinEndTime_s(int bin) {
        return this.getBinStartTime_s(bin + 1);
    }

    public int getEndTime_s() {
        return this.getBinStartTime_s(this.binCnt);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " start time = " + Time.strFromSec(this.startTime_s) + ", bin size = " + Time.strFromSec(this.binSize_s) + ", number of bins = " + this.binCnt + ".";
    }
}

