/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities;

import floetteroed.utilities.Tuple;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class TupleIterator<E>
implements Iterator<Tuple<E, E>> {
    private final Collection<E> elements;
    private Iterator<E> firstElementIterator = null;
    private Iterator<E> secondElementIterator = null;
    private E firstElement = null;

    public TupleIterator(Collection<E> elements) {
        this.elements = elements;
        this.firstElementIterator = elements.iterator();
        this.secondElementIterator = elements.iterator();
        if (this.firstElementIterator.hasNext()) {
            this.firstElement = this.firstElementIterator.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.firstElementIterator.hasNext() || this.secondElementIterator.hasNext();
    }

    @Override
    public Tuple<E, E> next() {
        if (!this.secondElementIterator.hasNext()) {
            this.firstElement = this.firstElementIterator.next();
            this.secondElementIterator = this.elements.iterator();
        }
        return new Tuple<E, E>(this.firstElement, this.secondElementIterator.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        List<String> elements = Arrays.asList("a", "b", "c");
        TupleIterator<String> it = new TupleIterator<String>(elements);
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }
}

