/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities;

import floetteroed.utilities.Tuple;
import floetteroed.utilities.TupleIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class TupleIteratorWithExclusions<E>
implements Iterator<Tuple<E, E>> {
    private final TupleIterator<E> fullIterator;
    private final Set<Tuple<E, E>> exceptions;
    private Tuple<E, E> next = null;

    public TupleIteratorWithExclusions(Collection<E> elements, Collection<Tuple<E, E>> exceptions) {
        this.fullIterator = new TupleIterator<E>(elements);
        this.exceptions = new LinkedHashSet<Tuple<Tuple<E, E>, Tuple<E, E>>>(exceptions);
        this.advance();
    }

    private void advance() {
        this.next = null;
        while (this.next == null && this.fullIterator.hasNext()) {
            Object candidate = this.fullIterator.next();
            if (this.exceptions.contains(candidate)) continue;
            this.next = candidate;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Tuple<E, E> next() {
        Tuple<E, E> result = this.next;
        this.advance();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        List<String> elements = Arrays.asList("a", "b", "c");
        List exclusions = Arrays.asList(new Tuple<String, String>("a", "c"), new Tuple<String, String>("b", "c"));
        TupleIteratorWithExclusions<String> it = new TupleIteratorWithExclusions<String>(elements, exclusions);
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }
}

