/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class XMLHelpers {
    public static final Extractor<Integer> DOUBLE2INT_EXTRACTOR = new Extractor<Integer>(){

        @Override
        public Integer extract(String item) {
            return (int)Math.round(Double.parseDouble(item));
        }
    };

    private XMLHelpers() {
    }

    public static <T> List<T> extractItems(String line, Extractor<T> extractor) {
        ArrayList<T> result = new ArrayList<T>();
        for (String item : line.split("\\s")) {
            String trimmedItem = item.trim();
            if (trimmedItem.length() <= 0) continue;
            result.add(extractor.extract(trimmedItem));
        }
        result.trimToSize();
        return result;
    }

    public static List<String> extractItems(String line) {
        return XMLHelpers.extractItems(line, new Extractor<String>(){

            @Override
            public String extract(String item) {
                return item;
            }
        });
    }

    public static void writeAttr(String name, Object value, PrintWriter writer) throws IOException {
        writer.print(name);
        writer.print("=\"");
        writer.print(value.toString());
        writer.print("\" ");
    }

    public static void appendAttr(String name, Object value, StringBuffer result) {
        result.append(name);
        result.append("=\"");
        result.append(value.toString());
        result.append("\" ");
    }

    public static interface Extractor<T> {
        public T extract(String var1);
    }
}

