/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.commandlineparser;

import floetteroed.utilities.commandlineparser.CommandLineParserElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CommandLineParser {
    public static final String KEY_PREFIX = "-";
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final Map<String, CommandLineParserElement> elements = new TreeMap<String, CommandLineParserElement>();
    private final Set<CommandLineParserElement> missingElements = new TreeSet<CommandLineParserElement>();
    private boolean isDone = false;

    public boolean defineParameter(String key, boolean required, String defaultValue, String explanation) {
        if (this.isDone) {
            return false;
        }
        this.elements.put(key.toUpperCase(), new CommandLineParserElement(key, required, defaultValue, explanation));
        return true;
    }

    public boolean parse(String[] args) {
        if (this.isDone) {
            return false;
        }
        if (args != null) {
            for (int i = 0; i < args.length; i += 2) {
                this.put(args[i], args[i + 1]);
            }
        }
        HashMap<String, String> defaults = new HashMap<String, String>();
        for (CommandLineParserElement element : this.elements.values()) {
            if (this.containsKey(element.getKey())) continue;
            if (element.getRequired()) {
                this.missingElements.add(element);
            }
            if (element.getDefaultValue() == null) continue;
            defaults.put(element.getKey(), element.getDefaultValue());
        }
        this.parameters.putAll(defaults);
        this.isDone = true;
        return true;
    }

    private void put(String key, String value) {
        this.parameters.put(key.toUpperCase(), value);
    }

    private String get(String key) {
        return this.parameters.get(key.toUpperCase());
    }

    public boolean containsKey(String key) {
        return this.parameters.containsKey(key.toUpperCase());
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean isComplete() {
        if (this.isDone) {
            return this.missingElements.size() == 0;
        }
        return false;
    }

    public Set<CommandLineParserElement> getMissingElements() {
        return Collections.unmodifiableSet(this.missingElements);
    }

    public Set<CommandLineParserElement> getElements() {
        return Collections.unmodifiableSet(new TreeSet<CommandLineParserElement>(this.elements.values()));
    }

    public boolean containsKeys(String ... keys) {
        if (keys != null) {
            for (String key : keys) {
                if (this.containsKey(key)) continue;
                return false;
            }
        }
        return true;
    }

    public String getString(String key) {
        return this.get(key);
    }

    public int getInteger(String key) {
        return Integer.parseInt(this.get(key));
    }

    public long getLong(String key) {
        return Long.parseLong(this.get(key));
    }

    public double getDouble(String key) {
        return Double.parseDouble(this.get(key));
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.get(key));
    }

    public String toString() {
        return this.parameters.toString();
    }
}

