/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.commandlineparser;

public class CommandLineParserElement
implements Comparable<CommandLineParserElement> {
    private final String key;
    private final String defaultValue;
    private final String explanation;
    private final boolean required;

    public CommandLineParserElement(String key, boolean required, String defaultValue, String explanation) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.key = key.toUpperCase();
        this.defaultValue = defaultValue;
        this.explanation = explanation;
        this.required = required;
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public boolean getRequired() {
        return this.required;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.key);
        if (this.required) {
            result.append(" : required; ");
        } else {
            result.append(" : optional; ");
        }
        result.append(this.explanation);
        result.append("; ");
        if (this.defaultValue == null) {
            result.append("no default value");
        } else {
            result.append("default = ");
            result.append(this.defaultValue);
        }
        return result.toString();
    }

    @Override
    public int compareTo(CommandLineParserElement arg0) {
        return this.getKey().compareTo(arg0.getKey());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            CommandLineParserElement otherElement = (CommandLineParserElement)o;
            return this.key.equals(otherElement.key);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

