/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.math;

import java.io.Serializable;

public class BasicStatistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int size;
    private double sum;
    private double sqrSum;
    private double min;
    private double max;

    public BasicStatistics() {
        this.clear();
    }

    public void clear() {
        this.size = 0;
        this.sum = 0.0;
        this.sqrSum = 0.0;
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
    }

    public void add(double val) {
        this.sum += val;
        this.sqrSum += val * val;
        this.min = Math.min(this.min, val);
        this.max = Math.max(this.max, val);
        ++this.size;
    }

    public BasicStatistics(Iterable<Double> iterable) {
        this();
        this.addAll(iterable);
    }

    public void addAll(Iterable<Double> iterable) {
        for (double val : iterable) {
            this.add(val);
        }
    }

    public int size() {
        return this.size;
    }

    public double getAvg() {
        return this.sum / (double)this.size;
    }

    public double getVar() {
        if (this.size() < 2) {
            return Double.POSITIVE_INFINITY;
        }
        return (this.sqrSum - this.sum * this.sum / (double)this.size) / ((double)this.size - 1.0);
    }

    public double getStddev() {
        return Math.sqrt(this.getVar());
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

