/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.math;

import floetteroed.utilities.math.Matrix;
import floetteroed.utilities.math.Vector;

public class Covariance {
    private final Matrix xySum;
    private final Vector xSum;
    private final Vector ySum;
    private int n;

    public Covariance(int xDim, int yDim) {
        if (xDim < 1) {
            throw new IllegalArgumentException("xDim is smaller than one");
        }
        if (yDim < 1) {
            throw new IllegalArgumentException("yDim is smaller than one");
        }
        this.xySum = new Matrix(xDim, yDim);
        this.xSum = new Vector(xDim);
        this.ySum = new Vector(yDim);
        this.n = 0;
    }

    public void add(Vector x, Vector y) {
        this.xySum.addOuterProduct(x, y, 1.0);
        this.xSum.add(x, 1.0);
        this.ySum.add(y, 1.0);
        ++this.n;
    }

    public Vector getMeanX() {
        Vector result = this.xSum.copy();
        result.mult(1.0 / (double)this.n);
        return result;
    }

    public Vector getMeanY() {
        Vector result = this.ySum.copy();
        result.mult(1.0 / (double)this.n);
        return result;
    }

    public Matrix getCovariance() {
        Matrix result = new Matrix(this.xSum.size(), this.ySum.size());
        result.add(this.xySum, 1.0 / ((double)this.n - 1.0));
        result.addOuterProduct(this.xSum, this.ySum, -1.0 / (double)this.n / ((double)this.n - 1.0));
        return result;
    }

    public static Matrix turnCovarianceIntoCorrelation(Matrix covariance) {
        int i;
        Matrix result = covariance;
        for (i = 0; i < result.rowSize(); ++i) {
            for (int j = 0; j < i; ++j) {
                double cov = result.getRow(i).get(j);
                double var1 = result.getRow(i).get(i);
                double var2 = result.getRow(j).get(j);
                double corr = cov / Math.sqrt(var1) / Math.sqrt(var2);
                result.getRow(i).set(j, corr);
                result.getRow(j).set(i, corr);
            }
        }
        for (i = 0; i < result.rowSize(); ++i) {
            result.getRow(i).set(i, 1.0);
        }
        return result;
    }

    public Matrix getCorrelation() {
        return Covariance.turnCovarianceIntoCorrelation(this.getCovariance());
    }
}

