/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.math;

import floetteroed.utilities.math.Regression;
import floetteroed.utilities.math.Vector;
import java.io.Serializable;

public class PolynomialTrendFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Regression regr;
    private int it = 0;

    public PolynomialTrendFilter(double lambda, int degree) {
        this.regr = new Regression(lambda, 1 + degree);
    }

    private Vector x(int it) {
        Vector result = new Vector(this.regr.getDimension());
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, Math.pow(it, i));
        }
        return result;
    }

    public void setLambda(double lambda) {
        this.regr.setInertia(lambda);
    }

    public void add(double val) {
        this.regr.update(this.x(this.it++), val);
    }

    public double predict(int steps) {
        return this.regr.predict(this.x(this.it - 1 + steps));
    }

    public Vector getRegressionCoefficients() {
        return this.regr.getCoefficients().copy();
    }
}

