/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.networks;

import floetteroed.utilities.networks.basic.BasicLink;
import floetteroed.utilities.networks.basic.BasicNetwork;
import floetteroed.utilities.networks.basic.BasicNetworkElement;
import floetteroed.utilities.networks.basic.BasicNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NetworkInverter {
    public static final String NETWORK_INVERTED_ATTRIBUTE = "inverted";
    public static final String NODE_ORIGINALFROMNODE_ID = "originalfromnode";
    public static final String NODE_ORIGINALTONODE_ID = "originaltonode";
    public static final String LINK_SUCCESSORS_ATTRIBUTE = "successors";

    private NetworkInverter() {
    }

    public static String newConnectionId(String from, String to) {
        return from + "__-->__" + to;
    }

    public static String newConnectionId(BasicNetworkElement from, BasicNetworkElement to) {
        return NetworkInverter.newConnectionId(from.getId(), to.getId());
    }

    private static List<String> successorIds(BasicLink link) {
        ArrayList<String> result = new ArrayList<String>(((BasicNode)link.getToNode()).getOutLinks().size());
        if (link.getAttr(LINK_SUCCESSORS_ATTRIBUTE) == null) {
            for (BasicLink succ : ((BasicNode)link.getToNode()).getOutLinks()) {
                result.add(succ.getId());
            }
        } else {
            for (String succId : link.getAttr(LINK_SUCCESSORS_ATTRIBUTE).split("\\s")) {
                result.add(succId.trim());
            }
        }
        return result;
    }

    public static BasicNetwork newInvertedNetwork(BasicNetwork originalNetwork) {
        if (originalNetwork.getAttr(NETWORK_INVERTED_ATTRIBUTE) != null && Boolean.parseBoolean(originalNetwork.getAttr(NETWORK_INVERTED_ATTRIBUTE))) {
            System.err.println("The network is already inverted. Returning the same instance.");
            return originalNetwork;
        }
        BasicNetwork newNetwork = new BasicNetwork(originalNetwork.getId(), originalNetwork.getType());
        newNetwork.setAttr(NETWORK_INVERTED_ATTRIBUTE, Boolean.toString(true));
        for (Map.Entry<String, String> entry : originalNetwork.getKey2NodesAttrView().entrySet()) {
            newNetwork.setNodesAttr(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : originalNetwork.getKey2LinksAttrView().entrySet()) {
            newNetwork.setLinksAttr(entry.getKey(), entry.getValue());
        }
        for (BasicLink originalLink : originalNetwork.getLinks()) {
            BasicNode newNode = new BasicNode(originalLink.getId());
            for (Map.Entry<String, String> entry : originalLink.getKey2AttributeView().entrySet()) {
                newNode.setAttr(entry.getKey(), entry.getValue());
            }
            newNode.setAttr(NODE_ORIGINALFROMNODE_ID, ((BasicNode)originalLink.getFromNode()).getId());
            newNode.setAttr(NODE_ORIGINALTONODE_ID, ((BasicNode)originalLink.getToNode()).getId());
            newNetwork.addNode(newNode);
        }
        for (BasicNode originalNode : originalNetwork.getNodes()) {
            for (BasicLink originalInLink : originalNode.getInLinks()) {
                for (String originalOutLinkId : NetworkInverter.successorIds(originalInLink)) {
                    BasicLink originalOutLink = (BasicLink)originalNetwork.getLink(originalOutLinkId);
                    BasicLink newLink = new BasicLink(NetworkInverter.newConnectionId(originalInLink.getId(), originalOutLinkId));
                    for (Map.Entry<String, String> entry : originalInLink.getKey2AttributeView().entrySet()) {
                        newLink.setAttr(entry.getKey(), entry.getValue());
                    }
                    BasicNode newFromNode = (BasicNode)newNetwork.getNode(originalInLink.getId());
                    BasicNode newToNode = (BasicNode)newNetwork.getNode(originalOutLink.getId());
                    BasicNetwork.connect(newFromNode, newToNode, newLink);
                    newNetwork.addLink(newLink);
                }
            }
        }
        return newNetwork;
    }
}

