/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.networks.construction;

import floetteroed.utilities.networks.construction.AbstractLink;
import floetteroed.utilities.networks.construction.AbstractNode;
import floetteroed.utilities.networks.construction.AttributeContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class AbstractNetwork<N extends AbstractNode<N, L>, L extends AbstractLink<N, L>>
extends AttributeContainer {
    private final String type;
    private Map<String, String> nodesAttr = new LinkedHashMap<String, String>();
    private Map<String, String> linksAttr = new LinkedHashMap<String, String>();
    private final Map<String, N> nodes = new LinkedHashMap<String, N>();
    private final Map<String, L> links = new LinkedHashMap<String, L>();

    public AbstractNetwork(String id, String type) {
        super(id);
        this.type = type;
    }

    protected void setNodesAttributes(Map<String, String> nodesAttributes) {
        this.nodesAttr = nodesAttributes;
    }

    protected void setLinksAttributes(Map<String, String> linksAttributes) {
        this.linksAttr = linksAttributes;
    }

    public static <N extends AbstractNode<N, L>, L extends AbstractLink<N, L>> void connect(N fromNode, N toNode, L link) {
        fromNode.getOutLinks().add(link);
        toNode.getInLinks().add(link);
        link.setFromNode(fromNode);
        link.setToNode(toNode);
    }

    public void setNodesAttr(String key, String value) {
        this.nodesAttr.put(key, value);
    }

    public String getNodesAttr(String key) {
        return this.nodesAttr.get(key);
    }

    public void setLinksAttr(String key, String value) {
        this.linksAttr.put(key, value);
    }

    public String getLinksAttr(String key) {
        return this.linksAttr.get(key);
    }

    public N addNode(N node) {
        return (N)((AbstractNode)this.nodes.put(((AttributeContainer)node).getId(), node));
    }

    public L addLink(L link) {
        return (L)((AbstractLink)this.links.put(((AttributeContainer)link).getId(), link));
    }

    public boolean isConsistent() {
        for (AbstractLink link : this.links.values()) {
            if (!this.nodes.containsValue(link.getFromNode())) {
                return false;
            }
            if (this.nodes.containsValue(link.getToNode())) continue;
            return false;
        }
        for (AbstractNode node : this.nodes.values()) {
            for (AbstractLink link : node.getInLinks()) {
                if (this.links.containsValue(link)) continue;
                return false;
            }
            for (AbstractLink link : node.getOutLinks()) {
                if (this.links.containsValue(link)) continue;
                return false;
            }
        }
        return true;
    }

    public String getType() {
        return this.type;
    }

    public N getNode(String nodeId) {
        return (N)((AbstractNode)this.nodes.get(nodeId));
    }

    public L getLink(String linkId) {
        return (L)((AbstractLink)this.links.get(linkId));
    }

    public L getLink(String fromNodeId, String toNodeId) {
        N fromNode = this.getNode(fromNodeId);
        if (fromNode == null) {
            return null;
        }
        for (AbstractLink link : ((AbstractNode)fromNode).getOutLinks()) {
            if (!((AttributeContainer)link.getToNode()).getId().equals(toNodeId)) continue;
            return (L)link;
        }
        return null;
    }

    public Collection<N> getNodes() {
        return this.nodes.values();
    }

    public Collection<L> getLinks() {
        return this.links.values();
    }

    public Map<String, String> getKey2NodesAttrView() {
        return Collections.unmodifiableMap(this.nodesAttr);
    }

    public Map<String, String> getKey2LinksAttrView() {
        return Collections.unmodifiableMap(this.linksAttr);
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getSimpleName());
        result.append("(id = ");
        result.append(this.getId());
        result.append(", #nodes = ");
        result.append(this.getNodes().size());
        result.append(", #links = ");
        result.append(this.getLinks().size());
        result.append(", super = ");
        result.append(super.toString());
        result.append(")");
        return result.toString();
    }
}

