/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.networks.construction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;

public class AttributeContainer {
    private final String id;
    private final int hashCode;
    private Map<String, String> key2attr = new LinkedHashMap<String, String>();

    protected void setAttributes(Map<String, String> attributes) {
        this.key2attr = attributes;
    }

    public AttributeContainer(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.id = id;
        this.hashCode = id.hashCode();
    }

    private String finalKey(String key) {
        return key;
    }

    public void setAttrs(Attributes attrs, String ... exceptionKeys) {
        List<String> exceptionKeyList = exceptionKeys == null ? new ArrayList<String>(0) : Arrays.asList(exceptionKeys);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String key = attrs.getQName(i);
            if (exceptionKeyList.contains(key)) continue;
            this.setAttr(key, attrs.getValue(i));
        }
    }

    public void setAttr(String key, String value) {
        this.key2attr.put(this.finalKey(key), value);
    }

    public Map<String, String> getKey2AttributeView() {
        return Collections.unmodifiableMap(this.key2attr);
    }

    public String getId() {
        return this.id;
    }

    public String getAttr(String key) {
        return this.key2attr.get(this.finalKey(key));
    }

    public boolean equals(Object o) {
        try {
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            AttributeContainer other = (AttributeContainer)o;
            return this.id.equals(other.id);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getSimpleName());
        result.append("(id = ");
        result.append(this.id);
        result.append(", attributes = ");
        result.append(this.key2attr.toString());
        result.append(")");
        return result.toString();
    }
}

