/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.networks.containerloaders;

import floetteroed.utilities.networks.construction.NetworkContainer;
import floetteroed.utilities.networks.containerloaders.NetworkContainerLoaderXML;
import org.xml.sax.Attributes;

public class MATSimNetworkContainerLoader
extends NetworkContainerLoaderXML {
    public static final String MATSIM_NETWORK_TYPE = "MATSim";
    public static final String NETWORK = "network";
    public static final String NETWORK_NAME = "name";
    public static final String NODES = "nodes";
    public static final String LINKS = "links";
    public static final String LINKS_CAPPERIOD = "capperiod";
    public static final String NODE = "node";
    public static final String NODE_ID = "id";
    public static final String LINK = "link";
    public static final String LINK_ID = "id";
    public static final String LINK_FROM = "from";
    public static final String LINK_TO = "to";
    public static final String LINK_LENGTH = "length";
    public static final String LINK_CAPACITY = "capacity";
    public static final String LINK_PERMLANES = "permlanes";
    public static final String LINK_FREESPEED = "freespeed";

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (NETWORK.equals(qName)) {
            this.startNetwork(attrs);
        } else if (NODES.equals(qName)) {
            this.startNodes(attrs);
        } else if (LINKS.equals(qName)) {
            this.startLinks(attrs);
        } else if (NODE.equals(qName)) {
            this.startNode(attrs);
        } else if (LINK.equals(qName)) {
            this.startLink(attrs);
        }
    }

    private void startNetwork(Attributes attrs) {
        String networkId = attrs.getValue(NETWORK_NAME);
        this.container = new NetworkContainer(networkId == null ? "" : networkId, MATSIM_NETWORK_TYPE);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String name = attrs.getQName(i);
            if (NETWORK_NAME.equals(name)) continue;
            this.container.putNetworkAttribute(name, attrs.getValue(i));
        }
    }

    private void startNodes(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            this.container.putNodeSetAttribute(attrs.getQName(i), attrs.getQName(i));
        }
    }

    private void startLinks(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            this.container.putLinkSetAttribute(attrs.getQName(i), attrs.getValue(i));
        }
    }

    private void startNode(Attributes attrs) {
        String nodeId = attrs.getValue("id");
        this.container.putNode(nodeId);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String name = attrs.getQName(i);
            if ("id".equals(name)) continue;
            this.container.putNodeAttribute(nodeId, name, attrs.getValue(i));
        }
    }

    private void startLink(Attributes attrs) {
        String linkId = attrs.getValue("id");
        this.container.putLink(linkId);
        this.container.setFromNode(linkId, attrs.getValue(LINK_FROM));
        this.container.setToNode(linkId, attrs.getValue(LINK_TO));
        for (int i = 0; i < attrs.getLength(); ++i) {
            String name = attrs.getQName(i);
            if ("id".equals(name) || LINK_FROM.equals(name) || LINK_TO.equals(name)) continue;
            this.container.putLinkAttribute(linkId, name, attrs.getValue(i));
        }
    }
}

