/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.networks.containerloaders;

import floetteroed.utilities.networks.construction.NetworkContainer;
import floetteroed.utilities.networks.containerloaders.NetworkContainerLoaderXML;
import org.xml.sax.Attributes;

public class OpenStreetMapNetworkContainerLoader
extends NetworkContainerLoaderXML {
    public static final String OPENSTREETMAP_NETWORK_TYPE = "OpenStreetMap";
    public static final String NODE = "node";
    public static final String NODE_ID = "id";
    public static final String WAY = "way";
    public static final String WAY_ID = "id";
    public static final String WAY_ND = "nd";
    public static final String WAY_ND_ID = "ref";
    private String currentLinkId = null;

    @Override
    public void startDocument() {
        this.container = new NetworkContainer("", OPENSTREETMAP_NETWORK_TYPE);
        this.currentLinkId = null;
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (NODE.equals(qName)) {
            this.startNode(attrs);
        } else if (WAY.equals(qName)) {
            this.startWay(attrs);
        } else if (WAY_ND.equals(qName)) {
            this.startWayNd(attrs);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (WAY.equals(qName)) {
            this.endWay();
        }
    }

    private void startNode(Attributes attrs) {
        String nodeId = attrs.getValue("id");
        this.container.putNode(nodeId);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String name = attrs.getQName(i);
            if ("id".equals(name)) continue;
            this.container.putNodeAttribute(nodeId, name, attrs.getValue(i));
        }
    }

    private void startWay(Attributes attrs) {
        this.currentLinkId = attrs.getValue("id");
        this.container.putLink(this.currentLinkId);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String name = attrs.getQName(i);
            if ("id".equals(name)) continue;
            this.container.putLinkAttribute(this.currentLinkId, name, attrs.getValue(i));
        }
    }

    private void startWayNd(Attributes attrs) {
        String nodeId = attrs.getValue(WAY_ND_ID);
        if (this.container.getFromNodeId(this.currentLinkId) == null) {
            this.container.setFromNode(this.currentLinkId, nodeId);
        } else {
            this.container.setToNode(this.currentLinkId, nodeId);
        }
    }

    private void endWay() {
        this.currentLinkId = null;
    }
}

