/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.networks.shortestpaths;

import floetteroed.utilities.networks.basic.BasicLink;
import floetteroed.utilities.networks.basic.BasicNetwork;
import floetteroed.utilities.networks.basic.BasicNode;
import floetteroed.utilities.networks.shortestpaths.LinkCost;
import floetteroed.utilities.networks.shortestpaths.LinkCostExcludingNodes;
import floetteroed.utilities.networks.shortestpaths.UnsettledNodes;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Router {
    protected final BasicNetwork network;
    protected final LinkCost linkCost;

    public Router(BasicNetwork network, LinkCost linkCost) {
        if (network == null) {
            throw new IllegalArgumentException("network is null");
        }
        if (linkCost == null) {
            throw new IllegalArgumentException("link cost is null");
        }
        this.network = network;
        this.linkCost = linkCost;
    }

    public BasicNetwork getNetwork() {
        return this.network;
    }

    static double treeCost(BasicNode node, Map<BasicNode, Double> treeCost) {
        Double result = treeCost.get(node);
        if (result == null) {
            return Double.POSITIVE_INFINITY;
        }
        return result;
    }

    private void expand(BasicNode currentNode, BasicNode candidateNode, BasicLink connectingLink, UnsettledNodes unsettled) {
        double oldCost = unsettled.cost(candidateNode);
        double newCost = this.linkCost.getCost(connectingLink) + unsettled.cost(currentNode);
        unsettled.update(candidateNode, Math.min(oldCost, newCost));
    }

    protected Map<BasicNode, Double> treeCost(BasicNode root, Set<BasicNode> targets, Direction direction, UnsettledNodes unsettled, Set<BasicNode> settled) {
        BasicNode currentNode;
        HashSet<Object> targetsLeft;
        if (targets == null) {
            targetsLeft = new HashSet<BasicNode>();
            targetsLeft.add(new BasicNode(">>>>> NON-EXISTING NODE <<<<<"));
        } else {
            targetsLeft = new HashSet<BasicNode>(targets);
        }
        if (unsettled == null) {
            unsettled = new UnsettledNodes();
            currentNode = root;
            unsettled.update(root, 0.0);
        } else {
            currentNode = unsettled.first();
        }
        if (settled == null) {
            settled = new HashSet<BasicNode>();
        }
        while (currentNode != null && !targetsLeft.isEmpty()) {
            if (Direction.FWD.equals((Object)direction)) {
                for (BasicLink outLink : currentNode.getOutLinks()) {
                    BasicNode outNode = (BasicNode)outLink.getToNode();
                    if (settled.contains(outNode)) continue;
                    this.expand(currentNode, outNode, outLink, unsettled);
                }
            } else {
                for (BasicLink inLink : currentNode.getInLinks()) {
                    BasicNode inNode = (BasicNode)inLink.getFromNode();
                    if (settled.contains(inNode)) continue;
                    this.expand(currentNode, inNode, inLink, unsettled);
                }
            }
            settled.add(currentNode);
            unsettled.remove(currentNode);
            targetsLeft.remove(currentNode);
            if (unsettled.isEmpty()) {
                currentNode = null;
                continue;
            }
            currentNode = unsettled.first();
        }
        return unsettled.cost();
    }

    private Map<BasicNode, Double> treeCost(BasicNode root, Set<BasicNode> targets, Direction direction) {
        return this.treeCost(root, targets, direction, null, null);
    }

    public Map<BasicNode, Double> fwdCost(BasicNode origin, Set<BasicNode> destinations) {
        return this.treeCost(origin, destinations, Direction.FWD);
    }

    public Map<BasicNode, Double> bwdCost(Set<BasicNode> origins, BasicNode destination) {
        return this.treeCost(destination, origins, Direction.BWD);
    }

    public Map<BasicNode, Double> fwdCost(BasicNode origin, BasicNode destination) {
        HashSet<BasicNode> destinations = new HashSet<BasicNode>();
        destinations.add(destination);
        return this.fwdCost(origin, destinations);
    }

    public Map<BasicNode, Double> fwdCost(BasicNode origin) {
        return this.fwdCost(origin, new HashSet<BasicNode>(this.network.getNodes()));
    }

    public Map<BasicNode, Double> bwdCost(BasicNode destination) {
        return this.bwdCost(new HashSet<BasicNode>(this.network.getNodes()), destination);
    }

    public Map<BasicNode, Double> bwdCost(BasicNode origin, BasicNode destination) {
        HashSet<BasicNode> origins = new HashSet<BasicNode>();
        origins.add(origin);
        return this.bwdCost(origins, destination);
    }

    private Map<BasicNode, LinkedList<BasicNode>> bestRoutes(Set<BasicNode> origins, BasicNode destination, Map<BasicNode, Double> bwdCostTree) {
        HashMap<BasicNode, LinkedList<BasicNode>> result = new HashMap<BasicNode, LinkedList<BasicNode>>();
        for (BasicNode origin : origins) {
            LinkedList<BasicNode> route = new LinkedList<BasicNode>();
            route.addFirst(origin);
            while (route != null && !((BasicNode)route.getLast()).equals(destination)) {
                BasicNode bestNode = null;
                double bestCost = Double.POSITIVE_INFINITY;
                for (BasicLink candLink : ((BasicNode)route.getLast()).getOutLinks()) {
                    BasicNode candNode = (BasicNode)candLink.getToNode();
                    double bwdCost = Router.treeCost(candNode, bwdCostTree);
                    double candCost = this.linkCost.getCost(candLink) + bwdCost;
                    if (!(candCost < bestCost)) continue;
                    bestNode = candNode;
                    bestCost = candCost;
                }
                if (Double.isInfinite(bestCost)) {
                    route = null;
                    continue;
                }
                route.addLast(bestNode);
            }
            result.put(origin, route);
        }
        return result;
    }

    private Map<BasicNode, LinkedList<BasicNode>> bestRoutes(BasicNode origin, Set<BasicNode> destinations, Map<BasicNode, Double> fwdCostTree) {
        HashMap<BasicNode, LinkedList<BasicNode>> result = new HashMap<BasicNode, LinkedList<BasicNode>>();
        for (BasicNode destination : destinations) {
            LinkedList<BasicNode> route = new LinkedList<BasicNode>();
            route.addLast(destination);
            while (route != null && !((BasicNode)route.getFirst()).equals(origin)) {
                BasicNode bestNode = null;
                double bestCost = Double.POSITIVE_INFINITY;
                for (BasicLink candLink : ((BasicNode)route.getFirst()).getInLinks()) {
                    BasicNode candNode = (BasicNode)candLink.getFromNode();
                    double fwdCost = Router.treeCost(candNode, fwdCostTree);
                    double candCost = this.linkCost.getCost(candLink) + fwdCost;
                    if (!(candCost < bestCost)) continue;
                    bestNode = candNode;
                    bestCost = candCost;
                }
                if (Double.isInfinite(bestCost)) {
                    route = null;
                    continue;
                }
                route.addFirst(bestNode);
            }
            result.put(destination, route);
        }
        return result;
    }

    public LinkedList<BasicNode> bestRouteBwd(BasicNode origin, BasicNode destination, Map<BasicNode, Double> bwdCost) {
        HashSet<BasicNode> origins = new HashSet<BasicNode>();
        origins.add(origin);
        return this.bestRoutes(origins, destination, bwdCost).get(origin);
    }

    public LinkedList<BasicNode> bestRouteFwd(BasicNode origin, BasicNode destination, Map<BasicNode, Double> fwdCost) {
        HashSet<BasicNode> destinations = new HashSet<BasicNode>();
        destinations.add(destination);
        return this.bestRoutes(origin, destinations, fwdCost).get(destination);
    }

    public Map<BasicNode, LinkedList<BasicNode>> bestRoutes(BasicNode origin, Set<BasicNode> destinations) {
        Map<BasicNode, Double> fwdCost = this.fwdCost(origin, destinations);
        return this.bestRoutes(origin, destinations, fwdCost);
    }

    public Map<BasicNode, LinkedList<BasicNode>> bestRoutes(Set<BasicNode> origins, BasicNode destination) {
        Map<BasicNode, Double> bwdCost = this.bwdCost(origins, destination);
        return this.bestRoutes(origins, destination, bwdCost);
    }

    public LinkedList<BasicNode> bestRoute(BasicNode origin, BasicNode destination) {
        HashSet<BasicNode> destinations = new HashSet<BasicNode>();
        destinations.add(destination);
        return this.bestRoutes(origin, destinations).get(destination);
    }

    public static boolean equals(List<BasicNode> route1, int start1, int end1, List<BasicNode> route2, int start2, int end2) {
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        for (int i = 0; i <= end1 - start1; ++i) {
            if (route1.get(start1 + i).equals(route2.get(start2 + i))) continue;
            return false;
        }
        return true;
    }

    private static BasicLink connectingLink(BasicNode from, BasicNode to) {
        for (BasicLink link : from.getOutLinks()) {
            if (!((BasicNode)link.getToNode()).equals(to)) continue;
            return link;
        }
        return null;
    }

    public static List<BasicLink> toLinkRoute(List<BasicNode> nodeRoute) {
        LinkedList<BasicLink> linkRoute = new LinkedList<BasicLink>();
        for (int i = 0; i < nodeRoute.size() - 1; ++i) {
            BasicLink link = Router.connectingLink(nodeRoute.get(i), nodeRoute.get(i + 1));
            if (link == null) {
                return null;
            }
            linkRoute.add(link);
        }
        return linkRoute;
    }

    public double cost(List<BasicLink> linkRoute) {
        double result = 0.0;
        for (BasicLink link : linkRoute) {
            result += this.linkCost.getCost(link);
        }
        return result;
    }

    public Map<BasicNode, Double> costWithoutExcludedNodes(BasicNode root, BasicNode target, Collection<BasicNode> allNodes, Collection<BasicNode> excludedNodes, Map<BasicNode, Double> treeCost, Direction direction) {
        if (excludedNodes.contains(root)) {
            throw new IllegalArgumentException("trying to compute SP cost tree with forbidden root");
        }
        if (excludedNodes.contains(target)) {
            throw new IllegalArgumentException("trying to compute SP cost tree to forbidden target");
        }
        LinkedHashSet<BasicNode> targets = new LinkedHashSet<BasicNode>();
        targets.add(target);
        LinkCostExcludingNodes myLinkCost = new LinkCostExcludingNodes(this.linkCost, excludedNodes);
        Router myRouter = new Router(this.getNetwork(), myLinkCost);
        Map<BasicNode, Double> myTreeCost = myRouter.treeCost(root, targets, direction, null, null);
        return myTreeCost;
    }

    public Map<BasicNode, Double> fwdCostWithoutExcludedNodes(BasicNode origin, BasicNode destination, Collection<BasicNode> allNodes, Collection<BasicNode> excludedNodes, Map<BasicNode, Double> fwdCost) {
        return this.costWithoutExcludedNodes(origin, destination, allNodes, excludedNodes, fwdCost, Direction.FWD);
    }

    public Map<BasicNode, Double> bwdCostWithoutExcludedNodes(BasicNode destination, BasicNode origin, Collection<BasicNode> allNodes, Collection<BasicNode> excludedNodes, Map<BasicNode, Double> bwdCost) {
        return this.costWithoutExcludedNodes(destination, origin, allNodes, excludedNodes, bwdCost, Direction.BWD);
    }

    protected static enum Direction {
        FWD,
        BWD;

    }
}

