/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.networks.shortestpaths;

import floetteroed.utilities.networks.basic.BasicNode;
import floetteroed.utilities.networks.shortestpaths.Router;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

class UnsettledNodes
implements Comparator<BasicNode> {
    private final Map<BasicNode, Double> treeCost = new HashMap<BasicNode, Double>();
    private final SortedSet<BasicNode> nodes = new TreeSet<BasicNode>(this);

    UnsettledNodes() {
    }

    boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    int size() {
        return this.nodes.size();
    }

    BasicNode first() {
        return this.nodes.first();
    }

    void remove(BasicNode node) {
        this.nodes.remove(node);
    }

    void update(BasicNode node, double cost) {
        this.nodes.remove(node);
        if (!Double.isInfinite(cost)) {
            this.treeCost.put(node, cost);
        }
        this.nodes.add(node);
    }

    Double cost(BasicNode node) {
        return Router.treeCost(node, this.treeCost);
    }

    Map<BasicNode, Double> cost() {
        return this.treeCost;
    }

    @Override
    public int compare(BasicNode n1, BasicNode n2) {
        int costResult = Double.compare(this.cost(n1), this.cost(n2));
        if (costResult != 0) {
            return costResult;
        }
        return n1.getId().toString().compareTo(n2.getId().toString());
    }
}

