/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.simulatedannealing;

import floetteroed.utilities.math.BasicStatistics;
import floetteroed.utilities.simulatedannealing.ProgressListener;
import floetteroed.utilities.simulatedannealing.SolutionEvaluator;
import floetteroed.utilities.simulatedannealing.SolutionGenerator;
import java.util.ArrayList;
import java.util.List;

public class SimulatedAnnealing<S> {
    private final SolutionGenerator<S> generator;
    private final SolutionEvaluator<S> evaluator;
    private final List<ProgressListener<S>> progressListeners = new ArrayList<ProgressListener<S>>();
    private boolean verbose = false;
    private boolean recomputeCurrentSolution = false;
    private double successThreshold = Double.NEGATIVE_INFINITY;
    private S xOpt;
    private double xQOpt;

    public SimulatedAnnealing(SolutionGenerator<S> generator, SolutionEvaluator<S> evaluator) {
        if (generator == null) {
            throw new IllegalArgumentException("generator is null");
        }
        if (evaluator == null) {
            throw new IllegalArgumentException("evaluator is null");
        }
        this.generator = generator;
        this.evaluator = evaluator;
        this.reset();
    }

    public void addListener(ProgressListener<S> listener) {
        if (listener != null) {
            this.progressListeners.add(listener);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setRecomputeCurrentSolution(boolean recomputeCurrentSolution) {
        this.recomputeCurrentSolution = recomputeCurrentSolution;
    }

    public void setSuccessThreshold(double successThreshold) {
        this.successThreshold = successThreshold;
    }

    public S getOptimalSolution() {
        return this.xOpt;
    }

    public double getOptimalEvaluation() {
        return this.xQOpt;
    }

    private void msg(int it, double xQ) {
        if (this.verbose) {
            System.out.println("it. " + it + ": f(x) = " + xQ + ", fOpt(x) = " + this.xQOpt + ", xOpt = " + this.xOpt);
        }
    }

    private S newRandomFeasibleSolution() {
        S x = null;
        while (!this.evaluator.feasible(x = (S)this.generator.randomGeneration())) {
        }
        return x;
    }

    private void updateBestSolution(S x, double xQ) {
        if (xQ < this.xQOpt) {
            this.xOpt = this.generator.copy(x);
            this.xQOpt = xQ;
        }
    }

    public void reset() {
        this.xOpt = null;
        this.xQOpt = Double.POSITIVE_INFINITY;
    }

    public double proposeGreediness(int maxPrepIt) {
        S x = null;
        double xQ = Double.POSITIVE_INFINITY;
        BasicStatistics stats = new BasicStatistics();
        for (int it = 1; it <= maxPrepIt; ++it) {
            x = this.newRandomFeasibleSolution();
            xQ = this.evaluator.evaluation(x);
            this.updateBestSolution(x, xQ);
            this.msg(it, xQ);
            stats.add(xQ);
        }
        return 1.0 / stats.getStddev();
    }

    public void run(S initialSolution, int maxIt, double greediness) {
        this.run(initialSolution, maxIt, greediness, maxIt);
    }

    public void run(S initialSolution, int maxIt, double greediness, int maxFailureIterations) {
        int failures = 0;
        S x = initialSolution == null ? this.newRandomFeasibleSolution() : initialSolution;
        double xQ = this.evaluator.evaluation(x);
        this.updateBestSolution(x, xQ);
        this.msg(1, xQ);
        for (ProgressListener<S> progressListener : this.progressListeners) {
            progressListener.notifyCurrentState(x, xQ, xQ);
        }
        for (int it = 2; it <= maxIt && xQ > this.successThreshold && failures < maxFailureIterations; ++it) {
            S y;
            while (!this.evaluator.feasible(y = this.generator.variation(x))) {
            }
            if (this.recomputeCurrentSolution) {
                xQ = this.evaluator.evaluation(x);
            }
            double yQ = this.evaluator.evaluation(y);
            this.updateBestSolution(y, yQ);
            if (Double.isInfinite(greediness)) {
                if (yQ < xQ) {
                    x = y;
                    xQ = yQ;
                    failures = 0;
                } else {
                    ++failures;
                }
            } else {
                double lambda = greediness * Math.log(it);
                double alpha = Math.exp(lambda * (xQ - yQ));
                if (Math.random() < alpha) {
                    x = y;
                    xQ = yQ;
                    failures = 0;
                } else {
                    ++failures;
                }
            }
            this.msg(it, xQ);
            for (ProgressListener<S> progressListener : this.progressListeners) {
                progressListener.notifyCurrentState(x, xQ, yQ);
            }
        }
    }
}

