/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.statisticslogging;

import floetteroed.utilities.statisticslogging.Statistic;
import floetteroed.utilities.statisticslogging.StatisticsWriter;
import java.util.LinkedHashMap;
import java.util.Map;

public class StatisticsMultiWriter<D> {
    private Map<String, StatisticsWriter<D>> fileName2statsWriter = new LinkedHashMap<String, StatisticsWriter<D>>();
    private final boolean append;

    public StatisticsMultiWriter(boolean append) {
        this.append = append;
    }

    public void addStatistic(String logFileName, Statistic<D> statistic) {
        StatisticsWriter<D> statsWriter = this.fileName2statsWriter.get(logFileName);
        if (statsWriter == null) {
            statsWriter = new StatisticsWriter(logFileName, this.append);
            this.fileName2statsWriter.put(logFileName, statsWriter);
        }
        statsWriter.addSearchStatistic(statistic);
    }

    public void writeToFile(D data, String ... labelOverrideValueSequence) {
        for (StatisticsWriter<D> statsWriter : this.fileName2statsWriter.values()) {
            statsWriter.writeToFile(data, labelOverrideValueSequence);
        }
    }
}

