/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.tabularfileparser;

import floetteroed.utilities.tabularfileparser.TabularFileHandler;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractTabularFileHandlerWithHeaderLine
implements TabularFileHandler {
    protected final Map<String, Integer> label2index = new LinkedHashMap<String, Integer>();
    private boolean parsedFirstRow = false;
    private String[] currentRow = null;

    protected int getCurrentRowSize() {
        return this.currentRow.length;
    }

    protected String getStringValue(String label) {
        return this.currentRow[this.label2index.get(label)];
    }

    protected Integer getIntValue(String label) {
        try {
            return Integer.parseInt(this.currentRow[this.label2index.get(label)]);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected Double getDoubleValue(String label) {
        try {
            return Double.parseDouble(this.currentRow[this.label2index.get(label)]);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public final void startRow(String[] row) {
        this.currentRow = row;
        if (!this.parsedFirstRow) {
            for (int i = 0; i < row.length; ++i) {
                this.label2index.put(this.preprocessColumnLabel(row[i]), i);
            }
            this.parsedFirstRow = true;
        } else {
            this.startDataRow(row);
            this.startCurrentDataRow();
        }
    }

    @Override
    public void startDocument() {
    }

    @Override
    public String preprocess(String line) {
        return line;
    }

    @Override
    public void endDocument() {
    }

    protected String preprocessColumnLabel(String label) {
        return label;
    }

    protected int index(String label) {
        return this.label2index.get(label);
    }

    public void startDataRow(String[] row) {
    }

    public void startCurrentDataRow() {
    }
}

