/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.visualization.AbstractRenderer;
import floetteroed.utilities.visualization.VisConfig;
import floetteroed.utilities.visualization.VisNetwork;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;

class BackgroundRenderer
extends AbstractRenderer {
    BackgroundRenderer(VisConfig visConfig, VisNetwork net) {
        super(visConfig, net);
    }

    @Override
    void myRendering(Graphics2D display, AffineTransform boxTransform) {
        Rectangle visRect = this.getComponent().getVisibleRect();
        display.setBackground(Color.WHITE);
        display.clearRect(visRect.x, visRect.y, visRect.width, visRect.height);
        String logo = this.getVisConfig().getLogo();
        if (logo != null && logo.length() > 0) {
            int targetLogoHeight = visRect.height * 8 / 10;
            int targetLogoWidth = visRect.width * 9 / 10;
            display.setFont(new Font(display.getFont().getName(), 1, targetLogoHeight));
            int trueLogoWidth = display.getFontMetrics().stringWidth(logo);
            double scaling = Math.min((double)targetLogoWidth / (double)trueLogoWidth, 1.0);
            int scaledLogoHeight = (int)Math.round(scaling * (double)targetLogoHeight);
            display.setFont(new Font(display.getFont().getName(), 0, scaledLogoHeight));
            int scaledLogoWidth = display.getFontMetrics().stringWidth(logo);
            display.setColor(Color.LIGHT_GRAY);
            int xCoord = visRect.x + (visRect.width - scaledLogoWidth) / 2;
            int yCoord = visRect.y + (visRect.height + scaledLogoHeight) / 2;
            display.drawString(logo, xCoord, yCoord);
        }
    }
}

