/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.Time;
import floetteroed.utilities.visualization.MoviePlayer;
import floetteroed.utilities.visualization.NetVis;
import floetteroed.utilities.visualization.Printer;
import floetteroed.utilities.visualization.RenderableDynamicData;
import floetteroed.utilities.visualization.VisConfig;
import floetteroed.utilities.visualization.VisLink;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ControlToolbar
extends JToolBar
implements ActionListener,
ItemListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String TO_START = "to_start";
    private static final String STEP_B = "step_b";
    private static final String PLAY = "play";
    private static final String STEP_F = "step_f";
    private static final String TO_END = "to_end";
    private static final String ZOOM_IN = "zoom_in";
    private static final String ZOOM_OUT = "zoom_out";
    private static final String SET_TIME = "set_time";
    private static final String TOGGLE_NODE_LABELS = "node labels";
    private static final String TOGGLE_LINK_LABELS = "link labels";
    private static final String TOGGLE_ANTIALIAS = "anti-alias";
    private static final String PRINT = "print";
    private final NetVis vis;
    private final RenderableDynamicData<VisLink> data;
    private final VisConfig visConfig;
    private Timer movieTimer = null;
    private JButton playButton = null;
    private JFormattedTextField timeField = null;
    private double scale = 1.0;

    ControlToolbar(NetVis viz, RenderableDynamicData<VisLink> data, VisConfig visConfig) {
        this.vis = viz;
        this.data = data;
        this.visConfig = visConfig;
        if (this.data != null) {
            this.add(this.createButton("|<", TO_START));
            this.add(this.createButton("<", STEP_B));
            this.playButton = this.createButton("PLAY", PLAY);
            this.add(this.playButton);
            this.add(this.createButton(">", STEP_F));
            this.add(this.createButton(">|", TO_END));
            this.timeField = new JFormattedTextField(new MessageFormat("{0,number,00}-{1,number,00}-{2,number,00}"));
            this.timeField.setMaximumSize(new Dimension(75, 30));
            this.timeField.setActionCommand(SET_TIME);
            this.timeField.setHorizontalAlignment(0);
            this.add(this.timeField);
            this.timeField.addActionListener(this);
        }
        this.add(this.createButton("--", ZOOM_OUT));
        this.add(this.createButton("+", ZOOM_IN));
        this.add(this.createButton("PRN", PRINT));
        JCheckBox nodeLabelBox = new JCheckBox(TOGGLE_NODE_LABELS);
        nodeLabelBox.setMnemonic(78);
        nodeLabelBox.setSelected(visConfig.getShowNodeLabels());
        nodeLabelBox.addItemListener(this);
        this.add(nodeLabelBox);
        JCheckBox linkLabelBox = new JCheckBox(TOGGLE_LINK_LABELS);
        linkLabelBox.setMnemonic(76);
        linkLabelBox.setSelected(visConfig.getShowLinkLabels());
        linkLabelBox.addItemListener(this);
        this.add(linkLabelBox);
        JCheckBox AABox = new JCheckBox(TOGGLE_ANTIALIAS);
        AABox.setMnemonic(65);
        AABox.setSelected(false);
        AABox.addItemListener(this);
        this.add(AABox);
        SpinnerNumberModel model = new SpinnerNumberModel(new Integer(this.visConfig.getLinkWidthFactor()), new Integer(0), new Integer(2000), new Integer(1));
        JLabel l = new JLabel("link width");
        this.add(l);
        JSpinner spin = new JSpinner(model);
        l.setLabelFor(spin);
        this.add(spin);
        spin.setMaximumSize(new Dimension(75, 30));
        spin.addChangeListener(this);
    }

    private JButton createButton(String display, String actionCommand) {
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.addActionListener(this);
        button.setText(display);
        return button;
    }

    void setScale(double scale) {
        this.scale = scale;
    }

    double getScale() {
        return this.scale;
    }

    private void updateTimeLabel() {
        if (this.data != null) {
            int time_s = this.data.getStartTime_s() + this.data.currentBin() * this.data.getBinSize_s();
            this.timeField.setText(Time.strFromSec(time_s));
        }
    }

    void repaintForMovie() {
        this.updateTimeLabel();
    }

    @Override
    public void paint(Graphics g) {
        if (this.data != null) {
            this.updateTimeLabel();
        }
        super.paint(g);
    }

    private void stopMovie() {
        if (this.movieTimer != null) {
            this.movieTimer.cancel();
            this.movieTimer = null;
            this.playButton.setText("PLAY");
        }
    }

    private void pressed_TO_START() throws IOException {
        this.stopMovie();
        this.data.toStart();
    }

    private void pressed_STEP_B() throws IOException {
        this.stopMovie();
        this.data.bwd();
    }

    private void pressed_PLAY() {
        if (this.movieTimer == null) {
            this.movieTimer = new Timer();
            MoviePlayer moviePlayer = new MoviePlayer(this.data, this.vis);
            this.movieTimer.schedule((TimerTask)moviePlayer, 0L, (long)this.visConfig.getDelay_ms());
            this.playButton.setText("STOP");
        } else {
            this.stopMovie();
        }
    }

    private void pressed_STEP_F() throws IOException {
        this.stopMovie();
        this.data.fwd();
    }

    private void pressed_TO_END() throws IOException {
        this.stopMovie();
        this.data.toEnd();
    }

    private void pressed_ZOOM_OUT() {
        this.scale /= 1.42;
        this.vis.scaleNetwork(this.scale);
    }

    private void pressed_ZOOM_IN() {
        this.scale *= 1.42;
        this.vis.scaleNetwork(this.scale);
    }

    private void pressed_PRINT() {
        new Printer(this.vis.networkComponent(), this.vis.networkScrollPane().getViewport()).run();
    }

    private void changed_SET_TIME(ActionEvent event) throws IOException {
        String newTime = ((JFormattedTextField)event.getSource()).getText();
        this.stopMovie();
        this.data.toTime(Time.secFromStr(newTime));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            if (TO_START.equals(command)) {
                this.pressed_TO_START();
            } else if (STEP_B.equals(command)) {
                this.pressed_STEP_B();
            } else if (PLAY.equals(command)) {
                this.pressed_PLAY();
            } else if (STEP_F.equals(command)) {
                this.pressed_STEP_F();
            } else if (TO_END.equals(command)) {
                this.pressed_TO_END();
            } else if (ZOOM_OUT.equals(command)) {
                this.pressed_ZOOM_OUT();
            } else if (ZOOM_IN.equals(command)) {
                this.pressed_ZOOM_IN();
            } else if (PRINT.equals(command)) {
                this.pressed_PRINT();
            } else if (command.equals(SET_TIME)) {
                this.changed_SET_TIME(event);
            }
        }
        catch (IOException e) {
            System.err.println("ControlToolbar encountered problem: " + e);
        }
        this.updateTimeLabel();
        this.repaint();
        this.vis.paintNow();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JCheckBox source = (JCheckBox)e.getItemSelectable();
        if (source.getText().equals(TOGGLE_NODE_LABELS)) {
            if (e.getStateChange() == 2) {
                this.visConfig.setShowNodeLabels(false);
            } else {
                this.visConfig.setShowNodeLabels(true);
            }
        } else if (source.getText().equals(TOGGLE_LINK_LABELS)) {
            if (e.getStateChange() == 2) {
                this.visConfig.setShowLinkLabels(false);
            } else {
                this.visConfig.setShowLinkLabels(true);
            }
        } else if (source.getText().equals(TOGGLE_ANTIALIAS)) {
            if (e.getStateChange() == 2) {
                this.visConfig.setUseAntiAliasing(false);
            } else {
                this.visConfig.setUseAntiAliasing(true);
            }
        }
        this.repaint();
        this.vis.paintNow();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSpinner spinner = (JSpinner)e.getSource();
        int i = ((SpinnerNumberModel)spinner.getModel()).getNumber().intValue();
        this.visConfig.setLinkWidthFactor(i);
        this.repaint();
        this.vis.paintNow();
    }
}

