/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.visualization.AbstractRenderer;
import floetteroed.utilities.visualization.NetJComponent;
import floetteroed.utilities.visualization.RenderableDynamicData;
import floetteroed.utilities.visualization.ValueColorizer;
import floetteroed.utilities.visualization.VisConfig;
import floetteroed.utilities.visualization.VisLink;
import floetteroed.utilities.visualization.VisNetwork;
import floetteroed.utilities.visualization.VisNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

class LinkRenderer
extends AbstractRenderer {
    private final ValueColorizer colorizer;
    private final RenderableDynamicData<VisLink> data;

    LinkRenderer(VisConfig visConfig, VisNetwork network, RenderableDynamicData<VisLink> data) {
        super(visConfig, network);
        this.data = data;
        this.colorizer = new ValueColorizer(visConfig.getColorDef());
    }

    @Override
    synchronized void myRendering(Graphics2D display, AffineTransform boxTransform) {
        this.drawLinks(true, display, boxTransform);
        this.drawLinks(false, display, boxTransform);
    }

    private void drawLinks(boolean zeros, Graphics2D display, AffineTransform boxTransform) {
        double laneWidth = 4.0 * (double)this.getVisConfig().getLinkWidthFactor();
        AffineTransform originalTransform = display.getTransform();
        display.setStroke(new BasicStroke(Math.round(0.05 * laneWidth)));
        NetJComponent comp = this.getComponent();
        for (VisLink link : this.getNetwork().getLinks()) {
            double endNorthing;
            double endEasting;
            double startNorthing;
            double startEasting;
            Double value;
            if (!link.getVisible()) continue;
            Double d = value = this.data == null ? null : Double.valueOf(this.data.getCurrentValue(link));
            if (value != null && (value == 0.0 || zeros) && (value != 0.0 || !zeros) || !comp.checkLineInClip(startEasting = ((VisNode)link.getFromNode()).getEasting(), startNorthing = ((VisNode)link.getFromNode()).getNorthing(), endEasting = ((VisNode)link.getToNode()).getEasting(), endNorthing = ((VisNode)link.getToNode()).getNorthing()) || startEasting == endEasting && startNorthing == endNorthing) continue;
            AffineTransform linkTransform = new AffineTransform(originalTransform);
            linkTransform.concatenate(boxTransform);
            linkTransform.concatenate(link.getTransform());
            display.setTransform(linkTransform);
            int lanes = this.getVisConfig().getMultiLane() ? link.getLanes() : 1;
            int linkLength_m = (int)Math.round(link.getLength_m());
            int cellWidth_m = (int)Math.round(laneWidth * (double)lanes);
            int cellStart_m = 0;
            if (value != null) {
                display.setColor(this.colorizer.getColor(value));
            } else {
                display.setColor(Color.WHITE);
            }
            display.fillRect(cellStart_m, -cellWidth_m, linkLength_m, cellWidth_m);
            display.setColor(Color.BLACK);
            display.drawRect(cellStart_m, -cellWidth_m, linkLength_m, cellWidth_m);
        }
        display.setTransform(originalTransform);
    }
}

