/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.visualization.BackgroundRenderer;
import floetteroed.utilities.visualization.ControlToolbar;
import floetteroed.utilities.visualization.LabelRenderer;
import floetteroed.utilities.visualization.LinkRenderer;
import floetteroed.utilities.visualization.NetJComponent;
import floetteroed.utilities.visualization.NetVisMouseHandler;
import floetteroed.utilities.visualization.NetVisScrollPane;
import floetteroed.utilities.visualization.NodeRenderer;
import floetteroed.utilities.visualization.RenderableDynamicData;
import floetteroed.utilities.visualization.VisConfig;
import floetteroed.utilities.visualization.VisLink;
import floetteroed.utilities.visualization.VisNetwork;
import floetteroed.utilities.visualization.VisNode;
import java.awt.Component;
import java.awt.geom.AffineTransform;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class NetVis {
    private JFrame vizFrame;
    private NetVisScrollPane networkScrollPane;
    private NetJComponent networkComponent;
    private ControlToolbar buttonComponent;

    public NetVis(VisConfig visConfig, VisNetwork net, RenderableDynamicData<VisLink> data) {
        LinkRenderer linkSetRenderer = new LinkRenderer(visConfig, net, data);
        BackgroundRenderer backgroundRenderer = new BackgroundRenderer(visConfig, net);
        NodeRenderer nodeSetRenderer = new NodeRenderer(visConfig, net);
        LabelRenderer mainRenderer = new LabelRenderer(visConfig, net);
        mainRenderer.append(linkSetRenderer);
        linkSetRenderer.append(nodeSetRenderer);
        nodeSetRenderer.append(backgroundRenderer);
        this.vizFrame = new JFrame(net.getId());
        this.vizFrame.setDefaultCloseOperation(3);
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.buttonComponent = new ControlToolbar(this, data, visConfig);
        this.vizFrame.getContentPane().add((Component)this.buttonComponent, "North");
        this.networkComponent = new NetJComponent(mainRenderer, visConfig);
        mainRenderer.setComponent(this.networkComponent);
        this.networkScrollPane = new NetVisScrollPane(this.networkComponent);
        this.vizFrame.getContentPane().add((Component)this.networkScrollPane, "Center");
        NetVisMouseHandler mouseHandler = new NetVisMouseHandler(this);
        this.networkScrollPane.addMouseMotionListener(mouseHandler);
        this.networkScrollPane.addMouseListener(mouseHandler);
        this.networkScrollPane.getViewport().addChangeListener(mouseHandler);
    }

    void scaleNetwork(double scale) {
        this.networkScrollPane.scaleNetwork((float)scale);
    }

    void repaintForMovie() {
        this.networkComponent.repaint();
        this.buttonComponent.repaintForMovie();
    }

    Component networkComponent() {
        return this.networkComponent;
    }

    NetVisScrollPane networkScrollPane() {
        return this.networkScrollPane;
    }

    ControlToolbar buttonComponent() {
        return this.buttonComponent;
    }

    public void paintNow() {
        if (this.vizFrame != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NetVis.this.vizFrame.paint(NetVis.this.vizFrame.getGraphics());
                }
            });
        }
    }

    public void run() {
        this.vizFrame.pack();
        this.vizFrame.setVisible(true);
    }

    static AffineTransform newLinear2PlaneTransform(double offset_m, double displayedLength_m, double startEasting, double startNorthing, double endEasting, double endNorthing, double length_m) {
        double tx = startEasting;
        double ty = startNorthing;
        AffineTransform result = AffineTransform.getTranslateInstance(tx, ty);
        double dx = endEasting - startEasting;
        double dy = endNorthing - startNorthing;
        double theta = Math.atan2(dy, dx);
        result.rotate(theta);
        double sx = displayedLength_m / length_m;
        double sy = 1.0;
        result.scale(sx, sy);
        tx = offset_m * length_m / displayedLength_m;
        ty = 0.0;
        result.translate(tx, ty);
        return result;
    }

    public static AffineTransform newLinear2PlaneTransform(VisLink link) {
        double offset_m;
        double startEasting = ((VisNode)link.getFromNode()).getEasting();
        double startNorthing = ((VisNode)link.getFromNode()).getNorthing();
        double endEasting = ((VisNode)link.getToNode()).getEasting();
        double endNorthing = ((VisNode)link.getToNode()).getNorthing();
        double deltaNorthing = endNorthing - startNorthing;
        double deltaEasting = endEasting - startEasting;
        double result = deltaNorthing * deltaNorthing;
        double nodeDist_m = Math.sqrt(result += deltaEasting * deltaEasting);
        double length_m = nodeDist_m - 2.0 * (offset_m = 0.0);
        if (length_m <= 0.0) {
            length_m = nodeDist_m / 2.0;
            offset_m = (nodeDist_m - length_m) / 2.0;
        }
        return NetVis.newLinear2PlaneTransform(offset_m, length_m, startEasting, startNorthing, endEasting, endNorthing, link.getLength_m());
    }
}

