/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.visualization.NetVis;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

class NetVisMouseHandler
extends MouseInputAdapter
implements ChangeListener {
    private final NetVis netVis;
    private Point start = null;
    private Rectangle currentRect = null;
    private int button = 0;

    NetVisMouseHandler(NetVis netVis) {
        this.netVis = netVis;
    }

    void updateSize(MouseEvent e) {
        this.currentRect = new Rectangle(this.start);
        this.currentRect.add(e.getX(), e.getY());
        this.netVis.networkScrollPane().getGraphics().drawRect(this.currentRect.x, this.currentRect.y, this.currentRect.width, this.currentRect.height);
        this.netVis.networkScrollPane().repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.button = e.getButton();
        this.start = new Point(x, y);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.button == 1) {
            this.updateSize(e);
        } else if (this.button == 2) {
            int deltax = this.start.x - e.getX();
            int deltay = this.start.y - e.getY();
            this.start.x = e.getX();
            this.start.y = e.getY();
            this.netVis.networkScrollPane().moveNetwork(deltax, deltay);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.button == 1) {
            this.updateSize(e);
            if (this.currentRect.getHeight() > 10.0 && this.currentRect.getWidth() > 10.0) {
                double scale = this.netVis.buttonComponent().getScale();
                scale = this.netVis.networkScrollPane().scaleNetwork(this.currentRect, scale);
                this.netVis.buttonComponent().setScale(scale);
            }
            this.currentRect = null;
        }
        this.button = 0;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.netVis.networkScrollPane().updateViewClipRect();
    }
}

