/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.visualization.NetJComponent;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JScrollPane;

class NetVisScrollPane
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private final NetJComponent networkComponent;

    NetVisScrollPane(NetJComponent networkComponent) {
        super(networkComponent);
        this.networkComponent = networkComponent;
    }

    void updateViewClipRect() {
        Dimension prefSize = this.networkComponent.getPreferredSize();
        Rectangle rect = this.getViewport().getViewRect();
        double relX = rect.getX() / prefSize.getWidth();
        double relY = rect.getY() / prefSize.getHeight();
        this.networkComponent.setViewClipCoords(relX, relY, relX + rect.getWidth() / prefSize.getWidth(), relY + rect.getHeight() / prefSize.getHeight());
    }

    void moveNetwork(int deltax, int deltay) {
        Rectangle rect = this.getViewport().getViewRect();
        rect.setLocation(rect.x + deltax, rect.y + deltay);
        this.getViewport().scrollRectToVisible(rect);
        this.getViewport().setViewPosition(rect.getLocation());
    }

    double scaleNetwork(Rectangle destrect, double factor) {
        Dimension prefSize = this.networkComponent.getPreferredSize();
        Rectangle rect = this.getViewport().getViewRect();
        double relX = (destrect.getX() + rect.getX()) / prefSize.getWidth();
        double relY = (destrect.getY() + rect.getY()) / prefSize.getHeight();
        this.networkComponent.scale(factor *= Math.min((double)rect.width / (double)destrect.width, (double)rect.height / (double)destrect.height));
        this.networkComponent.revalidate();
        Dimension prefSize2 = this.networkComponent.getPreferredSize();
        this.networkComponent.setViewClipCoords(relX, relY, relX + rect.getWidth() / prefSize2.getWidth(), relY + rect.getHeight() / prefSize2.getHeight());
        Point result = new Point();
        result.x = (int)(relX * prefSize2.getWidth());
        result.y = (int)(relY * prefSize2.getHeight());
        rect.setLocation(result.x, result.y);
        this.getViewport().scrollRectToVisible(rect);
        this.getViewport().setViewPosition(result);
        this.getViewport().toViewCoordinates(result);
        this.revalidate();
        this.repaint();
        return factor;
    }

    void scaleNetwork(double factor) {
        Dimension prefSize = this.networkComponent.getPreferredSize();
        Rectangle rect = this.getViewport().getViewRect();
        double relX = rect.getX() / prefSize.getWidth();
        double relY = rect.getY() / prefSize.getHeight();
        this.networkComponent.scale(factor);
        this.networkComponent.revalidate();
        Dimension prefSize2 = this.networkComponent.getPreferredSize();
        this.networkComponent.setViewClipCoords(relX, relY, relX + rect.getWidth() / prefSize2.getWidth(), relY + rect.getHeight() / prefSize2.getHeight());
        rect.x = (int)(relX * prefSize2.getWidth() + 0.5 * (rect.getWidth() * (prefSize2.getWidth() / prefSize.getWidth() - 1.0)));
        rect.y = (int)(relY * prefSize2.getHeight() + 0.5 * (rect.getHeight() * (prefSize2.getHeight() / prefSize.getHeight() - 1.0)));
        this.getViewport().setViewPosition(rect.getLocation());
        this.revalidate();
        this.repaint();
    }
}

