/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.visualization.AbstractRenderer;
import floetteroed.utilities.visualization.NetJComponent;
import floetteroed.utilities.visualization.VisConfig;
import floetteroed.utilities.visualization.VisNetwork;
import floetteroed.utilities.visualization.VisNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

class NodeRenderer
extends AbstractRenderer {
    private boolean renderNodes = false;

    NodeRenderer(VisConfig visConfig, VisNetwork network) {
        super(visConfig, network);
    }

    void setRenderNodes(boolean renderNodes) {
        this.renderNodes = renderNodes;
    }

    @Override
    synchronized void myRendering(Graphics2D display, AffineTransform boxTransform) {
        if (!this.renderNodes) {
            return;
        }
        double laneWidth = 4.0 * (double)this.getVisConfig().getLinkWidthFactor();
        NetJComponent comp = this.getComponent();
        AffineTransform originalTransform = display.getTransform();
        display.setStroke(new BasicStroke(Math.round(0.05 * laneWidth)));
        AffineTransform nodeTransform = new AffineTransform(originalTransform);
        nodeTransform.concatenate(boxTransform);
        display.setTransform(nodeTransform);
        for (VisNode node : this.getNetwork().getNodes()) {
            double y;
            double x = node.getEasting();
            if (!comp.checkLineInClip(x, y = node.getNorthing(), x, y)) continue;
            display.setColor(Color.WHITE);
            display.fillOval((int)(x - laneWidth), (int)(y - laneWidth), (int)(2.0 * laneWidth), (int)(2.0 * laneWidth));
            display.setColor(Color.BLACK);
            display.drawOval((int)(x - laneWidth), (int)(y - laneWidth), (int)(2.0 * laneWidth), (int)(2.0 * laneWidth));
        }
        display.setTransform(originalTransform);
    }
}

