/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.math.MathHelpers;
import floetteroed.utilities.networks.construction.AbstractNetwork;
import floetteroed.utilities.networks.construction.AbstractNode;
import floetteroed.utilities.networks.construction.NetworkPostprocessor;
import floetteroed.utilities.visualization.NetVis;
import floetteroed.utilities.visualization.VisLink;
import floetteroed.utilities.visualization.VisNetwork;
import floetteroed.utilities.visualization.VisNode;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class OpenStreetMap2VisNetwork
implements NetworkPostprocessor<VisNetwork> {
    public static final double EARTHRADIUS_M = 6378137.0;
    public static final String NODE_LONGITUDE_ATTRIBUTE = "lon";
    public static final String NODE_LATITUDE_ATTRIBUTE = "lat";

    @Override
    public void run(VisNetwork network) {
        Map<VisNode, Point2D.Double> node2xy = OpenStreetMap2VisNetwork.node2xy(network);
        double minEasting = Double.POSITIVE_INFINITY;
        double maxEasting = Double.NEGATIVE_INFINITY;
        double minNorthing = Double.POSITIVE_INFINITY;
        double maxNorthing = Double.NEGATIVE_INFINITY;
        for (Map.Entry<VisNode, Point2D.Double> entry : node2xy.entrySet()) {
            double easting = entry.getValue().x;
            double northing = entry.getValue().y;
            VisNode node = entry.getKey();
            node.setEasting(easting);
            node.setNorthing(northing);
            minEasting = Math.min(minEasting, easting);
            maxEasting = Math.max(maxEasting, easting);
            minNorthing = Math.min(minNorthing, northing);
            maxNorthing = Math.max(maxNorthing, northing);
        }
        network.setMinEasting(minEasting);
        network.setMaxEasting(maxEasting);
        network.setMinNorthing(minNorthing);
        network.setMaxNorthing(maxNorthing);
        for (VisLink link : network.getLinks()) {
            VisNode from = (VisNode)link.getFromNode();
            VisNode to = (VisNode)link.getToNode();
            link.setLength_m(MathHelpers.length(from.getEasting(), from.getNorthing(), to.getEasting(), to.getNorthing()));
            link.setLanes(1);
            link.setVisible(true);
            link.setTransform(NetVis.newLinear2PlaneTransform(link));
        }
    }

    public static <N extends AbstractNode<N, ?>, NET extends AbstractNetwork<N, ?>> Map<N, Point2D.Double> node2LonLat(NET network) {
        HashMap<AbstractNode, Point2D.Double> result = new HashMap<AbstractNode, Point2D.Double>();
        for (AbstractNode node : network.getNodes()) {
            double lon = Double.parseDouble(node.getAttr(NODE_LONGITUDE_ATTRIBUTE));
            double lat = Double.parseDouble(node.getAttr(NODE_LATITUDE_ATTRIBUTE));
            result.put(node, new Point2D.Double(lon, lat));
        }
        return result;
    }

    public static <N extends AbstractNode<N, ?>> Point2D.Double min(Map<N, Point2D.Double> node2pnt) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        for (Map.Entry<N, Point2D.Double> entry : node2pnt.entrySet()) {
            minX = Math.min(minX, entry.getValue().x);
            minY = Math.min(minY, entry.getValue().y);
        }
        return new Point2D.Double(minX, minY);
    }

    public static <N extends AbstractNode<N, ?>> Point2D.Double max(Map<N, Point2D.Double> node2pnt) {
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Map.Entry<N, Point2D.Double> entry : node2pnt.entrySet()) {
            maxX = Math.max(maxX, entry.getValue().x);
            maxY = Math.max(maxY, entry.getValue().y);
        }
        return new Point2D.Double(maxX, maxY);
    }

    public static <N extends AbstractNode<N, ?>> Map<N, Point2D.Double> node2xy(Map<N, Point2D.Double> node2LonLat) {
        HashMap<AbstractNode, Point2D.Double> result = new HashMap<AbstractNode, Point2D.Double>();
        Point2D.Double minLonLat = OpenStreetMap2VisNetwork.min(node2LonLat);
        double minLon = minLonLat.x;
        double minLat = minLonLat.y;
        for (AbstractNode node : node2LonLat.keySet()) {
            double easting = 6378137.0 * Math.tan((node2LonLat.get((Object)node).x - minLon) * Math.PI / 180.0);
            double northing = 6378137.0 * Math.tan((node2LonLat.get((Object)node).y - minLat) * Math.PI / 180.0);
            result.put(node, new Point2D.Double(easting, northing));
        }
        return result;
    }

    public static Map<VisNode, Point2D.Double> node2xy(VisNetwork network) {
        return OpenStreetMap2VisNetwork.node2xy(OpenStreetMap2VisNetwork.node2LonLat(network));
    }
}

