/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.DynamicData;

public class RenderableDynamicData<K>
extends DynamicData<K> {
    private static final long serialVersionUID = 1L;
    private int bin = 0;

    public RenderableDynamicData(int startTime_s, int binSize_s, int binCnt) {
        super(startTime_s, binSize_s, binCnt);
    }

    public RenderableDynamicData(DynamicData<K> data) {
        this(data.getStartTime_s(), data.getBinSize_s(), data.getBinCnt());
        for (K key : data.keySet()) {
            for (int bin = 0; bin < data.getBinCnt(); ++bin) {
                this.put(key, bin, data.getBinValue(key, bin));
            }
        }
    }

    int currentBin() {
        return this.bin;
    }

    void toStart() {
        this.bin = 0;
    }

    void toEnd() {
        this.bin = this.getBinCnt() - 1;
    }

    void toTime(int time_s) {
        this.bin = this.bin(time_s);
        if (this.bin < 0) {
            this.bin = 0;
        } else if (this.bin >= this.getBinCnt()) {
            this.bin = this.getBinCnt() - 1;
        }
    }

    void fwd() {
        ++this.bin;
        if (this.bin >= this.getBinCnt()) {
            this.bin = 0;
        }
    }

    void bwd() {
        --this.bin;
        if (this.bin < 0) {
            this.bin = this.getBinCnt() - 1;
        }
    }

    double getCurrentValue(K key) {
        return this.getBinValue(key, this.bin);
    }
}

