/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import java.awt.Color;

class ValueColorizer {
    private double[] values;
    private Color[] colors;

    ValueColorizer(String colordef) {
        try {
            String[] colordefs = colordef.trim().split("\\s");
            this.values = new double[colordefs.length / 2];
            this.colors = new Color[colordefs.length / 2];
            for (int i = 0; i < colordefs.length / 2; ++i) {
                this.colors[i] = (Color)Color.class.getField(colordefs[2 * i]).get(null);
                this.values[i] = Double.parseDouble(colordefs[1 + 2 * i]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int upperIndex(double val) {
        int result;
        for (result = 0; this.values[result] < val && result < this.values.length - 1; ++result) {
        }
        return result;
    }

    private int bound(double x) {
        return (int)Math.max(0L, Math.min(Math.round(x), 255L));
    }

    Color getColor(double value) {
        int u = this.upperIndex(value);
        if (u == 0) {
            return this.colors[0];
        }
        double w = (value - this.values[u - 1]) / (this.values[u] - this.values[u - 1]);
        int r = this.bound(w * (double)this.colors[u].getRed() + (1.0 - w) * (double)this.colors[u - 1].getRed());
        int g = this.bound(w * (double)this.colors[u].getGreen() + (1.0 - w) * (double)this.colors[u - 1].getGreen());
        int b = this.bound(w * (double)this.colors[u].getBlue() + (1.0 - w) * (double)this.colors[u - 1].getBlue());
        return new Color(r, g, b);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.values.length; ++i) {
            result.append(this.colors[i].toString());
            result.append(" ");
            result.append(this.values[i]);
            result.append(" ");
        }
        return result.toString();
    }
}

